/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_about.c
 *
 *  Code file for the about dialog.
 *  @Author : Damien Chavarria (1999)
 *
 */

#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"

GtkWidget *about;
GtkWidget *about_button;

void on_button_clicked (GtkButton *button, gpointer user_data)
{
  gtk_widget_hide(about);
  gtk_widget_destroy(about);
}

void xmps_about_create (void)
{
  GtkWidget *notebook2;
  GtkWidget *fixed1;
  GtkWidget *label6;
  GtkWidget *label5;
  GtkWidget *pixmap1;
  GtkWidget *label4;

  about = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (about), "about", about);
  gtk_widget_set_usize (about, 400, 0);
  gtk_container_set_border_width (GTK_CONTAINER (about), 5);
  gtk_window_set_title (GTK_WINDOW (about), "About XMPS");
  gtk_window_set_position (GTK_WINDOW (about), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (about), TRUE);

  notebook2 = gtk_notebook_new ();
  gtk_widget_ref (notebook2);
  gtk_object_set_data_full (GTK_OBJECT (about), "notebook2", notebook2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook2);
  gtk_container_add (GTK_CONTAINER (about), notebook2);

  fixed1 = gtk_fixed_new ();
  gtk_widget_ref (fixed1);
  gtk_object_set_data_full (GTK_OBJECT (about), "fixed1", fixed1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (notebook2), fixed1);
  gtk_container_set_border_width (GTK_CONTAINER (fixed1), 5);

  about_button = gtk_button_new_with_label ("OK");
  gtk_widget_ref (about_button);
  gtk_object_set_data_full (GTK_OBJECT (about), "about_button", about_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_button);
  gtk_fixed_put (GTK_FIXED (fixed1), about_button, 296, 264);
  gtk_widget_set_uposition (about_button, 296, 264);
  gtk_widget_set_usize (about_button, 85, 30);

  gtk_signal_connect (GTK_OBJECT (about_button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_clicked),
                      NULL);

  label6 = gtk_label_new ("Copyright (c) - 1999-2000 Damien Chavarria");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (about), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_fixed_put (GTK_FIXED (fixed1), label6, 48, 232);
  gtk_widget_set_uposition (label6, 48, 232);
  gtk_widget_set_usize (label6, 288, 24);

  label5 = gtk_label_new ("XMPS - X MPEG Player System version " VERSION);
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (about), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_fixed_put (GTK_FIXED (fixed1), label5, 56, 216);
  gtk_widget_set_uposition (label5, 56, 216);
  gtk_widget_set_usize (label5, 280, 16);

  pixmap1 = create_pixmap (about, "xmps_intro.xpm");
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (about), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_fixed_put (GTK_FIXED (fixed1), pixmap1, 184, 104);
  gtk_widget_set_uposition (pixmap1, 184, 104);
  gtk_widget_set_usize (pixmap1, 21, 21);

  label4 = gtk_label_new ("Credits");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (about), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 0), label4);

}

void xmps_about_show(void)
{
  gtk_widget_show(about);
}












