/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mpeg3protos.h"
#include <stdlib.h>

mpeg3_atrack_t* mpeg3_new_atrack(mpeg3_t *file, int stream_id, int format, mpeg3_demuxer_t *demuxer)
{
  mpeg3_atrack_t *new_atrack;
  
  new_atrack = calloc(1, sizeof(mpeg3_atrack_t));
  new_atrack->channels = 0;
  new_atrack->sample_rate = 0;
  new_atrack->total_samples = 0;
  new_atrack->current_position = 0;
  new_atrack->demuxer = mpeg3_new_demuxer(file, 1, 0, 0, stream_id);
  
  if(demuxer) {
    mpeg3demux_copy_titles(new_atrack->demuxer, demuxer);
  }

  return new_atrack;
}

int mpeg3_delete_atrack(mpeg3_t *file, mpeg3_atrack_t *atrack)
{
  if(atrack->demuxer) {
    mpeg3_delete_demuxer(atrack->demuxer);
  }

  free(atrack);
  
  return 0;
}

