/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPEG3PROTOS_H
#define MPEG3PROTOS_H

#include "libxmps/libxmps.h"
#include "mpeg3private.h"
#include "mpeg3demux.h"
#include "mpeg3title.h"
#include "mpeg3atrack.h"
#include "mpeg3vtrack.h"
#include "mpeg3strack.h"

mpeg3_t*         mpeg3_new(xmps_media_plugin_t *media);
int              mpeg3_delete(mpeg3_t *file);
mpeg3_demuxer_t* mpeg3_new_demuxer(mpeg3_t *file, int do_audio, int do_video, int do_sub, int stream_id);
int              mpeg3_delete_demuxer(mpeg3_demuxer_t *demuxer);
int              mpeg3demux_read_data(mpeg3_demuxer_t *demuxer, unsigned char *output, long size);
unsigned int     mpeg3demux_read_int32(mpeg3_demuxer_t *demuxer);
unsigned int     mpeg3demux_read_int24(mpeg3_demuxer_t *demuxer);
unsigned int     mpeg3demux_read_int16(mpeg3_demuxer_t *demuxer);
double           mpeg3demux_length(mpeg3_demuxer_t *demuxer);
mpeg3_demuxer_t* mpeg3_get_demuxer(mpeg3_t *file);
long             mpeg3demux_tell(mpeg3_demuxer_t *demuxer);
double           mpeg3demux_seek_percentage(mpeg3_demuxer_t *demuxer, double percentage);
double           mpeg3demux_tell_percentage(mpeg3_demuxer_t *demuxer);
double           mpeg3demux_get_time(mpeg3_demuxer_t *demuxer);
int              mpeg3demux_eof(mpeg3_demuxer_t *demuxer);
int              mpeg3demux_bof(mpeg3_demuxer_t *demuxer);
int              mpeg3demux_copy_titles(mpeg3_demuxer_t *dst, mpeg3_demuxer_t *src);
int              mpeg3demux_open_title(mpeg3_demuxer_t *demuxer, int title_number);
int              mpeg3demux_create_title(mpeg3_demuxer_t *demuxer, int timecode_search, FILE *toc);
unsigned int     mpeg3demux_read_prev_char_packet(mpeg3_demuxer_t *demuxer);
int              mpeg3demux_seek_byte(mpeg3_demuxer_t *demuxer, long byte);
long             mpeg3demuxer_total_bytes(mpeg3_demuxer_t *demuxer);
mpeg3_title_t*   mpeg3_new_title(mpeg3_t *file, xmps_media_plugin_t *media);
int              mpeg3_delete_title(mpeg3_title_t *title);
int              mpeg3_copy_title(mpeg3_title_t *dst, mpeg3_title_t *src);
mpeg3_atrack_t*  mpeg3_new_atrack(mpeg3_t *file, int stream_id, int is_ac3, mpeg3_demuxer_t *demuxer);
int              mpeg3_delete_atrack(mpeg3_t *file, mpeg3_atrack_t *atrack);
mpeg3_vtrack_t*  mpeg3_new_vtrack(mpeg3_t *file, int stream_id, mpeg3_demuxer_t *demuxer);
int              mpeg3_delete_vtrack(mpeg3_t *file, mpeg3_vtrack_t *vtrack);
mpeg3_fs_t*      mpeg3_new_fs(xmps_media_plugin_t *media);
int              mpeg3_delete_fs(mpeg3_fs_t *fs);
int              mpeg3io_open_file(mpeg3_fs_t *fs);
int              mpeg3io_close_file(mpeg3_fs_t *fs);
int              mpeg3io_read_data(unsigned char *buffer, long bytes, mpeg3_fs_t *fs);
int              mpeg3io_seek_relative(mpeg3_fs_t *fs, long bytes);
int              mpeg3io_seek(mpeg3_fs_t *fs, long byte);
int              mpeg3_copy_fs(mpeg3_fs_t *dst, mpeg3_fs_t *src);
mpeg3_strack_t*  mpeg3_new_strack(mpeg3_t *file, int stream_id, mpeg3_demuxer_t *demuxer);
int              mpeg3_delete_strack(mpeg3_t *file, mpeg3_strack_t *strack);
int              mpeg3demux_total_length(mpeg3_demuxer_t *demuxer);

#endif
