/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.PluginConverter;

public class AdvancedDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JTextField cabTextField;
    private JTextField nsTextField;
    private JTextField smartUpdateTextField;
    private JTextField mimeTypeTextField;
    private JTextField logTextField;
    private JButton resetButton;
    private JButton logButton;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox logCheckBox;
    private String logFileNameStr;
    private PluginConverter converter;
    private static final int WIDTH = 490;
    private static final int HEIGHT = 380;

    public AdvancedDialog(Frame frame, PluginConverter pluginConverter) {
        this(frame, ResourceHandler.getMessage("advanced_dialog.caption"), false, pluginConverter);
    }

    public AdvancedDialog(Frame frame, boolean bl, PluginConverter pluginConverter) {
        this(frame, ResourceHandler.getMessage("advanced_dialog.caption"), bl, pluginConverter);
    }

    public AdvancedDialog(Frame frame, String string, PluginConverter pluginConverter) {
        this(frame, string, false, pluginConverter);
    }

    public AdvancedDialog(Frame frame, String string, boolean bl, PluginConverter pluginConverter) {
        super(frame, string, bl);
        this.converter = pluginConverter;
        this.majorLayout();
        this.setup();
    }

    public void majorLayout() {
        ((Component)this).setSize(490, 380);
        this.setResizable(true);
        JLabel jLabel = new JLabel(ResourceHandler.getMessage("advanced_dialog.cab"));
        this.cabTextField = new JTextField();
        JLabel jLabel2 = new JLabel(ResourceHandler.getMessage("advanced_dialog.plugin"));
        this.nsTextField = new JTextField();
        JLabel jLabel3 = new JLabel(ResourceHandler.getMessage("advanced_dialog.smartupdate"));
        this.smartUpdateTextField = new JTextField();
        JLabel jLabel4 = new JLabel(ResourceHandler.getMessage("advanced_dialog.mimetype"));
        this.mimeTypeTextField = new JTextField();
        JLabel jLabel5 = new JLabel(ResourceHandler.getMessage("advanced_dialog.log"));
        this.logTextField = new JTextField();
        this.logButton = new JButton(ResourceHandler.getMessage("button.browse"));
        this.logButton.addActionListener(this);
        this.logCheckBox = new JCheckBox(ResourceHandler.getMessage("advanced_dialog.generate"));
        this.logCheckBox.addItemListener(this);
        this.resetButton = new JButton(ResourceHandler.getMessage("button.reset"));
        this.resetButton.addActionListener(this);
        this.okButton = new JButton(ResourceHandler.getMessage("button.okay"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ResourceHandler.getMessage("button.cancel"));
        this.cancelButton.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(this.resetButton);
        box.add(Box.createHorizontalGlue());
        box.add(this.cancelButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.okButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.cabTextField, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        gridBagLayout.setConstraints(jLabel2, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.nsTextField, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        gridBagLayout.setConstraints(jLabel3, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.smartUpdateTextField, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        gridBagLayout.setConstraints(jLabel4, new GridBagConstraints(0, 6, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.mimeTypeTextField, new GridBagConstraints(0, 7, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.logCheckBox, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(jLabel5, new GridBagConstraints(0, 9, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.logTextField, new GridBagConstraints(0, 10, 2, 1, 2.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.logButton, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 10), 0, 0));
        gridBagLayout.setConstraints(box, new GridBagConstraints(0, 11, 0, 1, 1.0, 0.0, 10, 2, new Insets(20, 10, 10, 10), 0, 0));
        this.getContentPane().add(jLabel);
        this.getContentPane().add(this.cabTextField);
        this.getContentPane().add(jLabel2);
        this.getContentPane().add(this.nsTextField);
        this.getContentPane().add(jLabel3);
        this.getContentPane().add(this.smartUpdateTextField);
        this.getContentPane().add(jLabel4);
        this.getContentPane().add(this.mimeTypeTextField);
        this.getContentPane().add(this.logCheckBox);
        this.getContentPane().add(jLabel5);
        this.getContentPane().add(this.logTextField);
        this.getContentPane().add(this.logButton);
        this.getContentPane().add(box);
    }

    private void setup() {
        this.cabTextField.setText(this.converter.getCabFileLocation());
        this.nsTextField.setText(this.converter.getNSFileLocation());
        this.smartUpdateTextField.setText(this.converter.getSmartUpdateLocation());
        this.mimeTypeTextField.setText(this.converter.getMimeType());
        this.logCheckBox.setSelected(this.converter.isCreateLog());
        this.enableLogTextField(this.logCheckBox.isSelected());
        File file = this.converter.getLogFile();
        if (file != null) {
            this.logFileNameStr = file.getName();
            this.logTextField.setText(file.getPath());
        }
    }

    public void resetDefaults() {
        this.cabTextField.setText(this.converter.getDefaultCabFileLocation());
        this.nsTextField.setText(this.converter.getDefaultNSFileLocation());
        this.smartUpdateTextField.setText(this.converter.getDefaultSmartUpdateLocation());
        this.mimeTypeTextField.setText(this.converter.getDefaultMimeType());
        this.logTextField.setText(this.converter.getDefaultLogFile().getPath());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.resetButton) {
            this.resetDefaults();
        } else if (component == this.okButton) {
            this.converter.setCabFileLocation(this.cabTextField.getText());
            this.converter.setNSFileLocation(this.nsTextField.getText());
            this.converter.setSmartUpdateLocation(this.smartUpdateTextField.getText());
            this.converter.setMimeType(this.mimeTypeTextField.getText());
            this.converter.setLogFile(new File(this.logTextField.getText()));
            this.converter.persistConverterSetting();
            this.setVisible(false);
            this.dispose();
        } else if (component == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (component == this.logButton) {
            JFileChooser jFileChooser = new JFileChooser();
            try {
                jFileChooser.setCurrentDirectory(new File(this.logTextField.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.logTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        if (bl) {
            super.pack();
        }
        super.setVisible(bl);
    }

    private void enableLogTextField(boolean bl) {
        this.logTextField.setEditable(bl);
        this.logButton.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Component component = (Component)itemEvent.getSource();
        if (component == this.logCheckBox) {
            this.converter.setCreateLog(this.logCheckBox.isSelected());
            this.enableLogTextField(this.logCheckBox.isSelected());
        }
    }
}

