/*
 * Decompiled with CFR 0.152.
 */
package demos.Paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Gradient
extends ControlsSurface {
    protected Color innerC;
    protected Color outerC;
    private DemoControls controls;

    public Gradient() {
        this.setBackground(Color.white);
        this.innerC = Color.green;
        this.outerC = Color.blue;
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3 = n / 2;
        int n4 = n2 / 2;
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.outerC, (float)n * 0.35f, (float)n2 * 0.35f, this.innerC));
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.setPaint(new GradientPaint(n, 0.0f, this.outerC, (float)n * 0.65f, (float)n2 * 0.35f, this.innerC));
        graphics2D.fillRect(n3, 0, n3, n4);
        graphics2D.setPaint(new GradientPaint(0.0f, n2, this.outerC, (float)n * 0.35f, (float)n2 * 0.65f, this.innerC));
        graphics2D.fillRect(0, n4, n3, n4);
        graphics2D.setPaint(new GradientPaint(n, n2, this.outerC, (float)n * 0.65f, (float)n2 * 0.65f, this.innerC));
        graphics2D.fillRect(n3, n4, n3, n4);
        graphics2D.setColor(Color.black);
        TextLayout textLayout = new TextLayout("GradientPaint", graphics2D.getFont(), graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, (int)((double)(n / 2) - textLayout.getBounds().getWidth() / 2.0), (int)((double)(n2 / 2) + textLayout.getBounds().getHeight() / 2.0));
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new Gradient());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Gradient demo;
        Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.blue, Color.lightGray, Color.cyan, Color.magenta};
        String[] colorName = new String[]{"Red", "Orange", "Yellow", "Green", "Blue", "lightGray", "Cyan", "Magenta"};
        JMenuItem[] innerMI = new JMenuItem[this.colors.length];
        JMenuItem[] outerMI = new JMenuItem[this.colors.length];
        ColoredSquare[] squares = new ColoredSquare[this.colors.length];
        JMenu imenu;
        JMenu omenu;

        public DemoControls(Gradient gradient) {
            super(gradient.name);
            this.demo = gradient;
            this.setBackground(Color.gray);
            JMenuBar jMenuBar = new JMenuBar();
            this.add(jMenuBar);
            JMenuBar jMenuBar2 = new JMenuBar();
            this.add(jMenuBar2);
            Font font = new Font("serif", 0, 10);
            this.imenu = jMenuBar.add(new JMenu("Inner Color"));
            this.imenu.setFont(font);
            this.imenu.setIcon(new ColoredSquare(gradient.innerC));
            this.omenu = jMenuBar2.add(new JMenu("Outer Color"));
            this.omenu.setFont(font);
            this.omenu.setIcon(new ColoredSquare(gradient.outerC));
            int n = 0;
            while (n < this.colors.length) {
                this.squares[n] = new ColoredSquare(this.colors[n]);
                this.innerMI[n] = this.imenu.add(new JMenuItem(this.colorName[n]));
                this.innerMI[n].setFont(font);
                this.innerMI[n].setIcon(this.squares[n]);
                this.innerMI[n].addActionListener(this);
                this.outerMI[n] = this.omenu.add(new JMenuItem(this.colorName[n]));
                this.outerMI[n].setFont(font);
                this.outerMI[n].setIcon(this.squares[n]);
                this.outerMI[n].addActionListener(this);
                ++n;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.colors.length) {
                if (actionEvent.getSource().equals(this.innerMI[n])) {
                    this.demo.innerC = this.colors[n];
                    this.imenu.setIcon(this.squares[n]);
                    break;
                }
                if (actionEvent.getSource().equals(this.outerMI[n])) {
                    this.demo.outerC = this.colors[n];
                    this.omenu.setIcon(this.squares[n]);
                    break;
                }
                ++n;
            }
            this.demo.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 31);
        }

        public void run() {
            if (this.demo.getImageType() <= 1) {
                this.demo.setImageType(2);
            }
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                int n = 0;
                while (n < this.innerMI.length) {
                    if (n != 4) {
                        try {
                            Thread.sleep(4444L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        this.innerMI[n].doClick();
                    }
                    ++n;
                }
            }
            this.thread = null;
        }

        class ColoredSquare
        implements Icon {
            Color color;

            public ColoredSquare(Color color) {
                this.color = color;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                graphics.fill3DRect(n, n2, this.getIconWidth(), this.getIconHeight(), true);
                graphics.setColor(color);
            }

            public int getIconWidth() {
                return 12;
            }

            public int getIconHeight() {
                return 12;
            }
        }
    }
}

