/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.jdi.AbstractLauncher;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.SunSDK;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.File;
import java.io.IOException;
import java.util.Map;

class SunCommandLineLauncher
extends AbstractLauncher
implements LaunchingConnector {
    private static final String ARG_HOME = "home";
    private static final String ARG_OPTIONS = "options";
    private static final String ARG_MAIN = "main";
    private static final String ARG_INIT_SUSPEND = "suspend";
    private static final String ARG_QUOTE = "quote";
    private static final String ARG_VM_EXEC = "vmexec";

    SunCommandLineLauncher(VirtualMachineManagerService virtualMachineManagerService, TransportService transportService) {
        super(virtualMachineManagerService, transportService);
        String string = SunSDK.home();
        if (string == null) {
            string = System.getProperty("java.home");
        }
        this.addStringArgument(ARG_HOME, this.getString("sun.home.label"), this.getString("sun.home"), string, false);
        this.addStringArgument(ARG_OPTIONS, this.getString("sun.options.label"), this.getString("sun.options"), "", false);
        this.addStringArgument(ARG_MAIN, this.getString("sun.main.label"), this.getString("sun.main"), "", true);
        this.addBooleanArgument(ARG_INIT_SUSPEND, this.getString("sun.init_suspend.label"), this.getString("sun.init_suspend"), true, false);
        this.addStringArgument(ARG_QUOTE, this.getString("sun.quote.label"), this.getString("sun.quote"), "\"", true);
        this.addStringArgument(ARG_VM_EXEC, this.getString("sun.vm_exec.label"), this.getString("sun.vm_exec"), "java", true);
    }

    static boolean hasWhitespace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (Character.isWhitespace(string.charAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public VirtualMachine launch(Map map) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachine virtualMachine;
        String string = this.argument(ARG_HOME, map).value();
        String string2 = this.argument(ARG_OPTIONS, map).value();
        String string3 = this.argument(ARG_MAIN, map).value();
        boolean bl = ((ConnectorImpl.BooleanArgumentImpl)this.argument(ARG_INIT_SUSPEND, map)).booleanValue();
        String string4 = this.argument(ARG_QUOTE, map).value();
        String string5 = this.argument(ARG_VM_EXEC, map).value();
        if (string4.length() > 1) {
            throw new IllegalConnectorArgumentsException("Invalid length", ARG_QUOTE);
        }
        if (string2.indexOf("-Djava.compiler=") != -1 && string2.toLowerCase().indexOf("-djava.compiler=none") == -1) {
            throw new IllegalConnectorArgumentsException("Cannot debug with a JIT compiler", ARG_OPTIONS);
        }
        String string6 = this.transportService().startListening();
        try {
            String string7;
            if (string.length() > 0) {
                string5 = string + File.separator + "bin" + File.separator + string5;
            }
            if (SunCommandLineLauncher.hasWhitespace(string5)) {
                string5 = string4 + string5 + string4;
            }
            if (SunCommandLineLauncher.hasWhitespace(string7 = "transport=" + this.transport().name() + ",address=" + string6 + ",suspend=" + (bl ? (char)'y' : 'n'))) {
                string7 = string4 + string7 + string4;
            }
            String string8 = string5 + ' ' + string2 + ' ' + "-Xdebug -Xnoagent -Djava.compiler=NONE " + "-Xrunjdwp:" + string7 + ' ' + string3;
            virtualMachine = this.launch(this.tokenizeCommand(string8, string4.charAt(0)), string6);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.transportService().stopListening(string6);
            throw throwable;
        }
        this.transportService().stopListening(string6);
        return virtualMachine;
    }

    public String name() {
        return "com.sun.jdi.CommandLineLaunch";
    }

    public String description() {
        return this.getString("sun.description");
    }
}

