/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import com.sun.corba.se.internal.util.RepositoryId;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.NameContext;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;

public class IDLNames
implements Constants {
    public static final byte[] ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String getMemberOrMethodName(NameContext nameContext, String string, BatchEnvironment batchEnvironment) {
        String string2 = (String)batchEnvironment.namesCache.get(string);
        if (string2 == null) {
            string2 = nameContext.get(string);
            string2 = IDLNames.convertLeadingUnderscores(string2);
            string2 = IDLNames.convertIDLKeywords(string2);
            string2 = IDLNames.convertToISOLatin1(string2);
            batchEnvironment.namesCache.put(string, string2);
        }
        return string2;
    }

    public static String convertToISOLatin1(String string) {
        String string2 = IDLNames.replace(string, "x\\u", "U");
        string2 = IDLNames.replace(string2, "x\\U", "U");
        int n = string2.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c > '\u00ff' || RepositoryId.IDL_IDENTIFIER_CHARS[c] == 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string2.substring(0, n2));
                }
                stringBuffer.append("U");
                stringBuffer.append((char)ASCII_HEX[(c & 0xF000) >>> 12]);
                stringBuffer.append((char)ASCII_HEX[(c & 0xF00) >>> 8]);
                stringBuffer.append((char)ASCII_HEX[(c & 0xF0) >>> 4]);
                stringBuffer.append((char)ASCII_HEX[c & 0xF]);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer != null) {
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String convertIDLKeywords(String string) {
        int n = 0;
        while (n < Constants.IDL_KEYWORDS.length) {
            if (string.equalsIgnoreCase(Constants.IDL_KEYWORDS[n])) {
                return "_" + string;
            }
            ++n;
        }
        return string;
    }

    public static String convertLeadingUnderscores(String string) {
        if (string.startsWith("_")) {
            return "J" + string;
        }
        return string;
    }

    public static String getClassOrInterfaceName(Identifier identifier, BatchEnvironment batchEnvironment) throws Exception {
        String string;
        String string2 = identifier.getName().toString();
        String string3 = null;
        if (identifier.isQualified()) {
            string3 = identifier.getQualifier().toString();
        }
        if ((string = (String)batchEnvironment.namesCache.get(string2)) == null) {
            string = IDLNames.replace(string2, ". ", "__");
            string = IDLNames.convertToISOLatin1(string);
            NameContext nameContext = NameContext.forName(string3, false, batchEnvironment);
            nameContext.assertPut(string);
            string = IDLNames.getTypeOrModuleName(string);
            batchEnvironment.namesCache.put(string2, string);
        }
        return string;
    }

    public static String getExceptionName(String string) {
        String string2 = string;
        string2 = string.endsWith("Exception") ? IDLNames.stripLeadingUnderscore(string.substring(0, string.lastIndexOf("Exception")) + "Ex") : string + "Ex";
        return string2;
    }

    public static String[] getModuleNames(Identifier identifier, boolean bl, BatchEnvironment batchEnvironment) throws Exception {
        String[] stringArray;
        String[] stringArray2 = null;
        if (identifier.isQualified()) {
            stringArray = identifier.getQualifier();
            batchEnvironment.modulesContext.assertPut(stringArray.toString());
            int n = 1;
            Object object = stringArray;
            while (((Identifier)object).isQualified()) {
                object = ((Identifier)object).getQualifier();
                ++n;
            }
            stringArray2 = new String[n];
            int n2 = n - 1;
            object = stringArray;
            int n3 = 0;
            while (n3 < n) {
                String string = ((Identifier)object).getName().toString();
                String string2 = (String)batchEnvironment.namesCache.get(string);
                if (string2 == null) {
                    string2 = IDLNames.convertToISOLatin1(string);
                    string2 = IDLNames.getTypeOrModuleName(string2);
                    batchEnvironment.namesCache.put(string, string2);
                }
                stringArray2[n2--] = string2;
                object = ((Identifier)object).getQualifier();
                ++n3;
            }
        }
        if (bl) {
            if (stringArray2 == null) {
                stringArray2 = Constants.IDL_BOXEDIDL_MODULE;
            } else {
                stringArray = new String[stringArray2.length + Constants.IDL_BOXEDIDL_MODULE.length];
                System.arraycopy(Constants.IDL_BOXEDIDL_MODULE, 0, stringArray, 0, Constants.IDL_BOXEDIDL_MODULE.length);
                System.arraycopy(stringArray2, 0, stringArray, Constants.IDL_BOXEDIDL_MODULE.length, stringArray2.length);
                stringArray2 = stringArray;
            }
        }
        return stringArray2;
    }

    public static String getArrayName(Type type, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("seq");
        stringBuffer.append(Integer.toString(n));
        stringBuffer.append("_");
        stringBuffer.append(IDLNames.replace(IDLNames.stripLeadingUnderscore(type.getIDLName()), " ", "_"));
        return stringBuffer.toString();
    }

    public static String[] getArrayModuleNames(Type type) {
        String[] stringArray;
        String[] stringArray2 = type.getIDLModuleNames();
        int n = stringArray2.length;
        if (n == 0) {
            stringArray = Constants.IDL_SEQUENCE_MODULE;
        } else {
            stringArray = new String[n + Constants.IDL_SEQUENCE_MODULE.length];
            System.arraycopy(Constants.IDL_SEQUENCE_MODULE, 0, stringArray, 0, Constants.IDL_SEQUENCE_MODULE.length);
            System.arraycopy(stringArray2, 0, stringArray, Constants.IDL_SEQUENCE_MODULE.length, n);
        }
        return stringArray;
    }

    private static int getInitialAttributeKind(CompoundType.Method method, BatchEnvironment batchEnvironment) throws ClassNotFound {
        int n = 0;
        if (!method.isConstructor()) {
            boolean bl = true;
            ValueType[] valueTypeArray = method.getExceptions();
            if (valueTypeArray.length > 0) {
                int n2 = 0;
                while (n2 < valueTypeArray.length) {
                    if (valueTypeArray[n2].isCheckedException() && !valueTypeArray[n2].isRemoteExceptionOrSubclass()) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            } else {
                bl = method.getEnclosing().isType(32768);
            }
            if (bl) {
                String string = method.getName();
                int n3 = string.length();
                int n4 = method.getArguments().length;
                Type type = method.getReturnType();
                boolean bl2 = type.isType(1);
                boolean bl3 = type.isType(2);
                if (string.startsWith("get") && n3 > 3 && n4 == 0 && !bl2) {
                    n = 2;
                } else if (string.startsWith("is") && n3 > 2 && n4 == 0 && bl3) {
                    n = 1;
                } else if (string.startsWith("set") && n3 > 3 && n4 == 1 && bl2) {
                    n = 5;
                }
            }
        }
        return n;
    }

    private static void setAttributeKinds(CompoundType.Method[] methodArray, int[] nArray, String[] stringArray) {
        Object object;
        int n;
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            switch (nArray[n3]) {
                case 2: {
                    stringArray[n3] = stringArray[n3].substring(3);
                    break;
                }
                case 1: {
                    stringArray[n3] = stringArray[n3].substring(2);
                    break;
                }
                case 5: {
                    stringArray[n3] = stringArray[n3].substring(3);
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] == 1) {
                n = 0;
                while (n < n2) {
                    Type type;
                    Type type2;
                    if (n != n4 && (nArray[n] == 2 || nArray[n] == 5) && stringArray[n4].equals(stringArray[n]) && !(type2 = methodArray[n4].getReturnType()).equals(type = nArray[n] == 2 ? methodArray[n].getReturnType() : methodArray[n].getArguments()[0])) {
                        nArray[n4] = 0;
                        stringArray[n4] = methodArray[n4].getName();
                        break;
                    }
                    ++n;
                }
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            if (nArray[n] == 5) {
                int n5 = -1;
                int n6 = 0;
                while (n6 < n2) {
                    Type type;
                    if (n6 != n && (nArray[n6] == 2 || nArray[n6] == 1) && stringArray[n].equals(stringArray[n6]) && ((Type)(object = methodArray[n6].getReturnType())).equals(type = methodArray[n].getArguments()[0])) {
                        n5 = n6;
                        break;
                    }
                    ++n6;
                }
                if (n5 < 0) {
                    nArray[n] = 0;
                    stringArray[n] = methodArray[n].getName();
                } else {
                    nArray[n5] = nArray[n5] == 2 ? 4 : 3;
                    methodArray[n5].setAttributePairIndex(n);
                    methodArray[n].setAttributePairIndex(n5);
                }
            }
            ++n;
        }
        int n7 = 0;
        while (n7 < n2) {
            String string;
            if (nArray[n7] != 0 && Character.isUpperCase((string = stringArray[n7]).charAt(0)) && (string.length() == 1 || Character.isLowerCase(string.charAt(1)))) {
                object = new StringBuffer(string);
                ((StringBuffer)object).setCharAt(0, Character.toLowerCase(string.charAt(0)));
                stringArray[n7] = ((StringBuffer)object).toString();
            }
            methodArray[n7].setAttributeKind(nArray[n7]);
            ++n7;
        }
    }

    public static void setMethodNames(CompoundType.Method[] methodArray, BatchEnvironment batchEnvironment) throws Exception {
        int n;
        Object object;
        int n2 = methodArray.length;
        if (n2 == 0) {
            return;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = methodArray[n3].getName();
            ++n3;
        }
        CompoundType compoundType = methodArray[0].getEnclosing();
        if (compoundType.isType(4096) || compoundType.isType(8192) || compoundType.isType(32768)) {
            object = new int[n2];
            n = 0;
            while (n < n2) {
                object[n] = IDLNames.getInitialAttributeKind(methodArray[n], batchEnvironment);
                ++n;
            }
            IDLNames.setAttributeKinds(methodArray, (int[])object, stringArray);
        }
        object = new NameContext(true);
        n = 0;
        while (n < n2) {
            ((NameContext)object).put(stringArray[n]);
            ++n;
        }
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            if (!methodArray[n4].isConstructor()) {
                stringArray[n4] = IDLNames.getMemberOrMethodName((NameContext)object, stringArray[n4], batchEnvironment);
            } else {
                stringArray[n4] = "create";
                bl = true;
            }
            ++n4;
        }
        boolean[] blArray = new boolean[n2];
        int n5 = 0;
        while (n5 < n2) {
            blArray[n5] = !methodArray[n5].isAttribute() && !methodArray[n5].isConstructor() && IDLNames.doesMethodCollide(stringArray[n5], methodArray[n5], methodArray, stringArray, true);
            ++n5;
        }
        IDLNames.convertOverloadedMethods(methodArray, stringArray, blArray);
        int n6 = 0;
        while (n6 < n2) {
            blArray[n6] = !methodArray[n6].isAttribute() && methodArray[n6].isConstructor() && IDLNames.doesConstructorCollide(stringArray[n6], methodArray[n6], methodArray, stringArray, true);
            ++n6;
        }
        IDLNames.convertOverloadedMethods(methodArray, stringArray, blArray);
        int n7 = 0;
        while (n7 < n2) {
            CompoundType.Method method = methodArray[n7];
            if (method.isAttribute() && IDLNames.doesMethodCollide(stringArray[n7], method, methodArray, stringArray, true)) {
                int n8 = n7;
                stringArray[n8] = stringArray[n8] + "__";
            }
            ++n7;
        }
        if (bl) {
            int n9 = 0;
            while (n9 < n2) {
                CompoundType.Method method = methodArray[n9];
                if (method.isConstructor() && IDLNames.doesConstructorCollide(stringArray[n9], method, methodArray, stringArray, false)) {
                    int n10 = n9;
                    stringArray[n10] = stringArray[n10] + "__";
                }
                ++n9;
            }
        }
        int n11 = 0;
        while (n11 < n2) {
            if (IDLNames.doesMethodCollide(stringArray[n11], methodArray[n11], methodArray, stringArray, false)) {
                throw new Exception(methodArray[n11].toString());
            }
            ++n11;
        }
        int n12 = 0;
        while (n12 < n2) {
            CompoundType.Method method = methodArray[n12];
            String string = stringArray[n12];
            if (method.isAttribute()) {
                string = Constants.ATTRIBUTE_WIRE_PREFIX[method.getAttributeKind()] + IDLNames.stripLeadingUnderscore(string);
                String string2 = stringArray[n12];
                method.setAttributeName(string2);
            }
            method.setIDLName(string);
            ++n12;
        }
    }

    private static String stripLeadingUnderscore(String string) {
        if (string != null && string.length() > 1 && string.charAt(0) == '_') {
            return string.substring(1);
        }
        return string;
    }

    private static void convertOverloadedMethods(CompoundType.Method[] methodArray, String[] stringArray, boolean[] blArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (blArray[n]) {
                CompoundType.Method method = methodArray[n];
                Type[] typeArray = method.getArguments();
                int n2 = 0;
                while (n2 < typeArray.length) {
                    int n3 = n;
                    stringArray[n3] = stringArray[n3] + "__";
                    String string = typeArray[n2].getQualifiedIDLName(false);
                    string = IDLNames.replace(string, "::_", "_");
                    string = IDLNames.replace(string, "::", "_");
                    string = IDLNames.replace(string, " ", "_");
                    int n4 = n;
                    stringArray[n4] = stringArray[n4] + string;
                    ++n2;
                }
                if (typeArray.length == 0) {
                    int n5 = n;
                    stringArray[n5] = stringArray[n5] + "__";
                }
                stringArray[n] = IDLNames.stripLeadingUnderscore(stringArray[n]);
            }
            ++n;
        }
    }

    private static boolean doesMethodCollide(String string, CompoundType.Method method, CompoundType.Method[] methodArray, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < methodArray.length) {
            CompoundType.Method method2 = methodArray[n];
            if (!(method == method2 || method2.isConstructor() || bl && method2.isAttribute() || !string.equals(stringArray[n]))) {
                int n2 = method.getAttributeKind();
                int n3 = method2.getAttributeKind();
                if (n2 == 0 || n3 == 0 || (n2 != 5 || n3 == 5) && (n3 != 5 || n2 == 5)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private static boolean doesConstructorCollide(String string, CompoundType.Method method, CompoundType.Method[] methodArray, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < methodArray.length) {
            CompoundType.Method method2 = methodArray[n];
            if (method != method2 && method2.isConstructor() == bl && string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void setMemberNames(CompoundType.Member[] memberArray, CompoundType.Method[] methodArray, BatchEnvironment batchEnvironment) throws Exception {
        String string;
        NameContext nameContext = new NameContext(true);
        int n = 0;
        while (n < memberArray.length) {
            nameContext.put(memberArray[n].getName());
            ++n;
        }
        int n2 = 0;
        while (n2 < memberArray.length) {
            CompoundType.Member member = memberArray[n2];
            string = IDLNames.getMemberOrMethodName(nameContext, member.getName(), batchEnvironment);
            member.setIDLName(string);
            ++n2;
        }
        int n3 = 0;
        while (n3 < memberArray.length) {
            string = memberArray[n3].getIDLName();
            int n4 = 0;
            while (n4 < memberArray.length) {
                if (n3 != n4 && memberArray[n4].getIDLName().equals(string)) {
                    throw new Exception(string);
                }
                ++n4;
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < memberArray.length) {
            String string2 = memberArray[n5].getIDLName();
            int n6 = 0;
            while (n6 < methodArray.length) {
                if (n5 != n6 && methodArray[n6].getIDLName().equals(string2)) {
                    memberArray[n5].setIDLName(string2 + "_");
                }
                ++n6;
            }
            ++n5;
        }
    }

    public static String getTypeName(int n, boolean bl) {
        String string = null;
        switch (n) {
            case 1: {
                string = "void";
                break;
            }
            case 2: {
                string = "boolean";
                break;
            }
            case 4: {
                string = "octet";
                break;
            }
            case 8: {
                string = "wchar";
                break;
            }
            case 16: {
                string = "short";
                break;
            }
            case 32: {
                string = "long";
                break;
            }
            case 64: {
                string = "long long";
                break;
            }
            case 128: {
                string = "float";
                break;
            }
            case 256: {
                string = "double";
                break;
            }
            case 1024: {
                string = "any";
                break;
            }
            case 2048: {
                string = "Object";
                break;
            }
            case 512: {
                string = bl ? "wstring" : "WStringValue";
            }
        }
        return string;
    }

    public static String getQualifiedName(String[] stringArray, String string) {
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (n == 0) {
                    string2 = stringArray[0];
                } else {
                    string2 = string2 + "::";
                    string2 = string2 + stringArray[n];
                }
                ++n;
            }
            string2 = string2 + "::";
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2, 0);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            int n2 = string2.length();
            int n3 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n3, n));
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string.indexOf(string2, n3);
            }
            if (n3 < string.length()) {
                stringBuffer.append(string.substring(n3));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getIDLRepositoryID(String string) {
        return "IDL:" + IDLNames.replace(string, "::", "/") + ":1.0";
    }

    private static String getTypeOrModuleName(String string) {
        String string2 = IDLNames.convertLeadingUnderscores(string);
        return IDLNames.convertIDLKeywords(string2);
    }
}

