/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import sun.tools.agent.Agent;
import sun.tools.agent.Breakpoint;
import sun.tools.agent.CachedClass;

class ObjectCache {
    private int sequenceNumber = 1;
    private Hashtable objectKey;
    private Object[] objects;
    private int reclaimIndex = -1;
    private final int initSize = 20;
    private final int firstSeqNum = 1;
    private final Object reclaimed = new Object();

    public ObjectCache() {
        this.objectKey = new Hashtable();
        this.objects = new Object[20];
    }

    public Object getObject(int n) {
        if (n == 0) {
            return null;
        }
        if (n > this.sequenceNumber || n < 0) {
            throw new IllegalArgumentException("objNum " + n + " sequenceNumber " + this.sequenceNumber);
        }
        return this.objects[n];
    }

    private int addObject(Object object) {
        Object[] objectArray;
        int n = -1;
        while (this.reclaimIndex != -1) {
            if (this.reclaimIndex > this.sequenceNumber) {
                this.reclaimIndex = -1;
                continue;
            }
            if (this.objects[this.reclaimIndex] != this.reclaimed) {
                ++this.reclaimIndex;
                continue;
            }
            n = this.reclaimIndex;
            break;
        }
        if (n == -1) {
            ++this.sequenceNumber;
            if (this.sequenceNumber >= this.objects.length) {
                objectArray = new Object[2 * this.objects.length];
                int n2 = 1;
                while (n2 < this.objects.length) {
                    objectArray[n2] = this.objects[n2];
                    ++n2;
                }
                this.objects = objectArray;
            }
            n = this.sequenceNumber;
        }
        objectArray = new Integer(n);
        this.objectKey.put(object, objectArray);
        this.objects[n] = object;
        return n;
    }

    public int getId(Object object) {
        if (object == null) {
            return 0;
        }
        Object v = this.objectKey.get(object);
        return v == null ? this.addObject(object) : ((Integer)v).intValue();
    }

    public Enumeration elements() {
        return new Enumeration(){
            int inx = 1;

            public boolean hasMoreElements() {
                while (this.inx <= ObjectCache.this.sequenceNumber && ObjectCache.this.objects[this.inx] == ObjectCache.this.reclaimed) {
                    ++this.inx;
                }
                return this.inx <= ObjectCache.this.sequenceNumber;
            }

            public Object nextElement() {
                return ObjectCache.this.objects[this.inx++];
            }
        };
    }

    public void free(int n) {
        Object object = this.getObject(n);
        this.objectKey.remove(object);
        this.objects[n] = this.reclaimed;
        if (this.reclaimIndex == -1 || this.reclaimIndex > n) {
            this.reclaimIndex = n;
        }
    }

    public void freeAllBut(int[] nArray) {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < nArray.length) {
            this.addReferences(hashSet, this.objects[nArray[n]]);
            ++n;
        }
        Breakpoint[] breakpointArray = Breakpoint.listBreakpoints();
        int n2 = 0;
        while (n2 < breakpointArray.length) {
            this.addReferences(hashSet, breakpointArray[n2].getRealClass());
            ++n2;
        }
        Hashtable hashtable = this.objectKey;
        Object[] objectArray = this.objects;
        this.objectKey = new Hashtable();
        this.objects = new Object[objectArray.length];
        int n3 = 1;
        while (n3 < objectArray.length) {
            this.objects[n3] = this.reclaimed;
            ++n3;
        }
        HashSet hashSet2 = new HashSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Integer n4 = null;
            if (object instanceof Class) {
                if ((object = CachedClass.findCachedClass((Class)object)) != null) {
                    hashSet2.add(object);
                    n4 = (Integer)hashtable.get(object);
                }
            } else {
                n4 = (Integer)hashtable.get(object);
            }
            if (n4 == null) continue;
            Agent.message("sending back " + object + " with key " + n4);
            int n5 = n4;
            this.objectKey.put(object, n4);
            this.objects[n5] = object;
        }
        CachedClass.freeAllBut(hashSet2);
        hashtable.clear();
        int n6 = 0;
        while (n6 < objectArray.length) {
            objectArray[n6] = null;
            ++n6;
        }
        hashSet2.clear();
        hashSet.clear();
        int n7 = 0;
        while (n7 < breakpointArray.length) {
            breakpointArray[n7] = null;
            ++n7;
        }
        hashtable = null;
        objectArray = null;
        hashSet2 = null;
        hashSet = null;
        breakpointArray = null;
        System.gc();
        this.reclaimIndex = 1;
    }

    protected void addReferences(Set set, Object object) {
        if (object != null && set.add(object)) {
            Agent.message("addref: " + object);
            this.addReferences(set, object.getClass());
            if (object instanceof Class) {
                Class clazz = (Class)object;
                this.addReferences(set, clazz.getSuperclass());
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    this.addReferences(set, classArray[n]);
                    ++n;
                }
                this.addReferences(set, clazz.getClassLoader());
            }
        }
    }
}

