/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.serialver;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import sun.tools.serialver.Res;
import sun.tools.serialver.SerialVerFrame;

public class SerialVer
extends Applet {
    GridBagLayout gb;
    TextField classname_t;
    Button show_b;
    TextField serialversion_t;
    Label footer_l;
    static URLClassLoader loader = null;

    public synchronized void init() {
        this.gb = new GridBagLayout();
        this.setLayout(this.gb);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        Label label = new Label(Res.getText("FullClassName"));
        label.setAlignment(2);
        this.gb.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.classname_t = new TextField(20);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this.gb.setConstraints(this.classname_t, gridBagConstraints);
        this.add(this.classname_t);
        this.show_b = new Button(Res.getText("Show"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this.gb.setConstraints(this.show_b, gridBagConstraints);
        this.add(this.show_b);
        Label label2 = new Label(Res.getText("SerialVersion"));
        label2.setAlignment(2);
        gridBagConstraints.gridwidth = 1;
        this.gb.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        this.serialversion_t = new TextField(50);
        this.serialversion_t.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        this.gb.setConstraints(this.serialversion_t, gridBagConstraints);
        this.add(this.serialversion_t);
        this.footer_l = new Label();
        gridBagConstraints.gridwidth = 0;
        this.gb.setConstraints(this.footer_l, gridBagConstraints);
        this.add(this.footer_l);
        this.classname_t.requestFocus();
    }

    public void start() {
        this.classname_t.requestFocus();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.classname_t) {
            this.show((String)event.arg);
            return true;
        }
        if (event.target == this.show_b) {
            this.show(this.classname_t.getText());
            return true;
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        boolean bl = super.handleEvent(event);
        return bl;
    }

    void show(String string) {
        try {
            this.footer_l.setText("");
            this.serialversion_t.setText("");
            if (string.equals("")) {
                return;
            }
            String string2 = SerialVer.serialSyntax(string);
            if (string2 != null) {
                this.serialversion_t.setText(string2);
            } else {
                this.footer_l.setText(Res.getText("NotSerializable", string));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.footer_l.setText(Res.getText("ClassNotFound", string));
        }
    }

    static void initializeLoader(String string) throws MalformedURLException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = stringTokenizer.countTokens();
        URL[] uRLArray = new URL[n];
        int n2 = 0;
        while (n2 < n) {
            uRLArray[n2] = new File(new File(stringTokenizer.nextToken()).getCanonicalPath()).toURL();
            ++n2;
        }
        loader = new URLClassLoader(uRLArray);
    }

    static String serialSyntax(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string, true, loader);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return "    static final long serialVersionUID = " + objectStreamClass.getSerialVersionUID() + "L;";
        }
        return null;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = null;
        int n = 0;
        if (stringArray.length == 0) {
            SerialVer.usage();
            System.exit(1);
        }
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-show")) {
                bl = true;
            } else if (stringArray[n].equals("-classpath")) {
                if (n + 1 == stringArray.length || stringArray[n + 1].startsWith("-")) {
                    System.err.println(Res.getText("error.missing.classpath"));
                    SerialVer.usage();
                    System.exit(1);
                }
                string = new String(stringArray[n + 1]);
                ++n;
            } else {
                if (!stringArray[n].startsWith("-")) break;
                System.err.println(Res.getText("invalid.flag", stringArray[n]));
                SerialVer.usage();
                System.exit(1);
            }
            ++n;
        }
        if (string == null && (string = System.getProperty("env.class.path")) == null) {
            string = ".";
        }
        try {
            SerialVer.initializeLoader(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(Res.getText("error.parsing.classpath", string));
            System.exit(2);
        }
        catch (IOException iOException) {
            System.err.println(Res.getText("error.parsing.classpath", string));
            System.exit(3);
        }
        if (!bl) {
            if (n == stringArray.length) {
                SerialVer.usage();
                System.exit(1);
            }
            while (n < stringArray.length) {
                try {
                    String string2 = SerialVer.serialSyntax(stringArray[n]);
                    if (string2 != null) {
                        System.out.println(stringArray[n] + ":" + string2);
                    } else {
                        System.err.println(Res.getText("NotSerializable", stringArray[n]));
                        System.exit(1);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(Res.getText("ClassNotFound", stringArray[n]));
                    System.exit(1);
                }
                ++n;
            }
        } else {
            if (n < stringArray.length) {
                System.err.println(Res.getText("ignoring.classes"));
                System.exit(1);
            }
            SerialVerFrame serialVerFrame = new SerialVerFrame();
            SerialVer serialVer = new SerialVer();
            serialVer.init();
            serialVerFrame.add("Center", serialVer);
            serialVerFrame.pack();
            serialVerFrame.show();
        }
    }

    public static void usage() {
        System.err.println(Res.getText("usage"));
    }
}

