/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.sound.midi.MidiSystem;
import javax.sound.sampled.AudioSystem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JavaSound
extends JPanel
implements ChangeListener,
Runnable {
    Vector demos = new Vector(4);
    JTabbedPane tabPane = new JTabbedPane();
    int width = 760;
    int height = 500;
    int index;

    public JavaSound(String string) {
        JMenuItem jMenuItem;
        JMenu jMenu;
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        if (JavaSoundApplet.applet == null) {
            jMenu = jMenuBar.add(new JMenu("File"));
            jMenuItem = jMenu.add(new JMenuItem("Exit"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
        jMenu = jMenuBar.add(new JMenu("Options"));
        jMenuItem = jMenu.add(new JMenuItem("Applet Info"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaSound.showInfoDialog();
            }
        });
        this.add((Component)jMenuBar, "North");
        this.tabPane.addChangeListener(this);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bevelBorder = new BevelBorder(1);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, bevelBorder);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(0, 0, 90, 0)));
        Juke juke = new Juke(string);
        jPanel.add(juke);
        this.demos.add(juke);
        this.tabPane.addTab("Juke Box", jPanel);
        new Thread(this).start();
        this.add((Component)this.tabPane, "Center");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.close();
        System.gc();
        this.index = this.tabPane.getSelectedIndex();
        this.open();
    }

    public void close() {
        ((ControlContext)this.demos.get(this.index)).close();
    }

    public void open() {
        ((ControlContext)this.demos.get(this.index)).open();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public static void showInfoDialog() {
        new Thread(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, "When running the Java Sound demo as an applet these permissions\nare necessary in order to load/save files and record audio :  \n\ngrant { \n  permission java.io.FilePermission \"<<ALL FILES>>\", \"read, write\";\n  permission javax.sound.sampled.AudioPermission \"record\"; \n  permission java.util.PropertyPermission \"user.dir\", \"read\";\n}; \n\nThe permissions need to be added to the .java.policy file.", "Applet Info", 1);
            }
        }).start();
    }

    public void run() {
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bevelBorder = new BevelBorder(1);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, bevelBorder);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(0, 0, 90, 0)));
        CapturePlayback capturePlayback = new CapturePlayback();
        this.demos.add(capturePlayback);
        jPanel.add(capturePlayback);
        this.tabPane.addTab("Capture/Playback", jPanel);
        MidiSynth midiSynth = new MidiSynth();
        this.demos.add(midiSynth);
        this.tabPane.addTab("Midi Synthesizer", midiSynth);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(0, 0, 5, 20)));
        Groove groove = new Groove();
        this.demos.add(groove);
        jPanel.add(groove);
        this.tabPane.addTab("Groove Box", jPanel);
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        try {
            if (MidiSystem.getSequencer() == null) {
                System.err.println("MidiSystem Sequencer Unavailable, exiting!");
                System.exit(1);
            } else if (AudioSystem.getMixer(null) == null) {
                System.err.println("AudioSystem Unavailable, exiting!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        String string = "media";
        if (stringArray.length > 0) {
            serializable = new File(stringArray[0]);
            if (serializable == null && !((File)serializable).isDirectory()) {
                System.out.println("usage: java JavaSound audioDirectory");
            } else {
                string = stringArray[0];
            }
        }
        serializable = new JavaSound(string);
        JFrame jFrame = new JFrame("Java Sound Demo");
        jFrame.addWindowListener(new WindowAdapter((JavaSound)serializable){
            private final /* synthetic */ JavaSound val$demo;
            {
                this.val$demo = javaSound;
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                this.val$demo.open();
            }

            public void windowIconified(WindowEvent windowEvent) {
                this.val$demo.close();
            }
        });
        jFrame.getContentPane().add("Center", (Component)serializable);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - ((JavaSound)serializable).width / 2, dimension.height / 2 - ((JavaSound)serializable).height / 2);
        ((Component)jFrame).setSize(new Dimension(((JavaSound)serializable).width, ((JavaSound)serializable).height));
        ((Component)jFrame).setVisible(true);
    }
}

