/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "config.h"
#include "gqmpeg.h"

static GtkWidget *configwindow;
static GtkWidget *mixer_entry;
static GtkWidget *initial_playlist_entry;
static GtkWidget *initial_directory_entry;
static GtkWidget *default_skin_entry;
static GtkWidget *preset_name_entry[10];
static GtkWidget *preset_file_entry[10];

static gint c_initial_playlist_mode;
static gint c_initial_directory_enable;
static gint c_show_playlist_on_startup;
static gint c_start_playing_on_startup;
static gint c_obey_mode_in_playlist;
static gint c_show_dot_files;
static gint c_disable_filtering;
static gint c_read_header_tags;
static gint c_playlist_accounting;
static gint c_smart_window_placement;
static gint c_remember_window_position;
static gint c_mixer_device_id;
static gint c_wm_decorations;
static gint c_play_presets;
static gint c_show_extra_winamp_info;
static gint c_double_size_mode;
static gint c_allow_ipc;
static gint c_prev_includes_current;
static gint c_drop_single_to_playlist;

static void prev_includes_current_clicked(GtkWidget *w, gpointer data);
static void allow_ipc_clicked(GtkWidget *w, gpointer data);
static void double_size_mode_clicked(GtkWidget *w, gpointer data);
static void show_extra_winamp_info_clicked(GtkWidget *w, gpointer data);
static void play_presets_clicked(GtkWidget *w, gpointer data);
static void mixer_device_id_cb(GtkWidget *w, gpointer data);
static void set_current_playlist_clicked(GtkWidget *w, gpointer data);
static void set_current_dir_clicked(GtkWidget *w, gpointer data);
static void initial_playlist_empty_selected(GtkWidget *w, gpointer data);
static void initial_playlist_session_selected(GtkWidget *w, gpointer data);
static void initial_playlist_file_selected(GtkWidget *w, gpointer data);
static void initial_directory_enable_clicked(GtkWidget *w, gpointer data);
static void start_playing_clicked(GtkWidget *w, gpointer data);
static void show_playlist_clicked(GtkWidget *w, gpointer data);
static void obey_playlist_clicked(GtkWidget *w, gpointer data);
static void hidden_files_clicked(GtkWidget *w, gpointer data);
static void filter_files_clicked(GtkWidget *w, gpointer data);
static void drop_single_clicked(GtkWidget *w, gpointer data);
static void window_placement_clicked(GtkWidget *w, gpointer data);
static void window_position_clicked(GtkWidget *w, gpointer data);
static void header_tags_clicked(GtkWidget *w, gpointer data);
static void playlist_accounting_clicked(GtkWidget *w, gpointer data);
static void wm_decorations_clicked(GtkWidget *w, gpointer data);
static void skin_item_selected(GtkWidget *clist, gint row, gint column,
		GdkEventButton *bevent, gpointer data);
static gint sort_skin_list_cb(void *a, void *b);
static void populate_skin_list(GtkWidget *clist);
static void hide_configuration_window();
static void ok_configuration_window();
static void apply_configuration_window();
static void create_config_window(gint start_tab);

static void prev_includes_current_clicked(GtkWidget *w, gpointer data)
{
	c_prev_includes_current = GTK_TOGGLE_BUTTON (w)->active;
}

static void allow_ipc_clicked(GtkWidget *w, gpointer data)
{
	c_allow_ipc = GTK_TOGGLE_BUTTON (w)->active;
}

static void double_size_mode_clicked(GtkWidget *w, gpointer data)
{
	c_double_size_mode = GTK_TOGGLE_BUTTON (w)->active;
}

static void show_extra_winamp_info_clicked(GtkWidget *w, gpointer data)
{
	c_show_extra_winamp_info = GTK_TOGGLE_BUTTON (w)->active;
}

static void play_presets_clicked(GtkWidget *w, gpointer data)
{
	c_play_presets = GTK_TOGGLE_BUTTON (w)->active;
}

static void mixer_device_id_cb(GtkWidget *w, gpointer data)
{
	gchar *dev_text = data;
	gint d = get_mixer_device_id(dev_text);
	if (d >= 0) c_mixer_device_id = d;
}

static void set_current_playlist_clicked(GtkWidget *w, gpointer data)
{
	if (!isfile(playlist_pathname)) return;
	gtk_entry_set_text(GTK_ENTRY(initial_playlist_entry),playlist_pathname);
}

static void set_current_dir_clicked(GtkWidget *w, gpointer data)
{
	if (!isdir(current_path)) return;
	gtk_entry_set_text(GTK_ENTRY(initial_directory_entry), current_path);
}

static void initial_playlist_empty_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_initial_playlist_mode = PLAYLIST_MODE_EMPTY;
}

static void initial_playlist_session_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_initial_playlist_mode = PLAYLIST_MODE_SESSION;
}

static void initial_playlist_file_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_initial_playlist_mode = PLAYLIST_MODE_FILE;
}

static void initial_directory_enable_clicked(GtkWidget *w, gpointer data)
{
	c_initial_directory_enable = GTK_TOGGLE_BUTTON (w)->active;
}

static void start_playing_clicked(GtkWidget *w, gpointer data)
{
	c_start_playing_on_startup = GTK_TOGGLE_BUTTON (w)->active;
}

static void show_playlist_clicked(GtkWidget *w, gpointer data)
{
	c_show_playlist_on_startup = GTK_TOGGLE_BUTTON (w)->active;
}

static void obey_playlist_clicked(GtkWidget *w, gpointer data)
{
	c_obey_mode_in_playlist = GTK_TOGGLE_BUTTON (w)->active;
}

static void hidden_files_clicked(GtkWidget *w, gpointer data)
{
	c_show_dot_files = GTK_TOGGLE_BUTTON (w)->active;
}

static void filter_files_clicked(GtkWidget *w, gpointer data)
{
	c_disable_filtering = GTK_TOGGLE_BUTTON (w)->active;
}

static void drop_single_clicked(GtkWidget *w, gpointer data)
{
	c_drop_single_to_playlist = GTK_TOGGLE_BUTTON (w)->active;
}

static void window_placement_clicked(GtkWidget *w, gpointer data)
{
	c_smart_window_placement = GTK_TOGGLE_BUTTON (w)->active;
}

static void window_position_clicked(GtkWidget *w, gpointer data)
{
	c_remember_window_position = GTK_TOGGLE_BUTTON (w)->active;
}

static void header_tags_clicked(GtkWidget *w, gpointer data)
{
	c_read_header_tags = GTK_TOGGLE_BUTTON (w)->active;
}

static void playlist_accounting_clicked(GtkWidget *w, gpointer data)
{
	c_playlist_accounting = GTK_TOGGLE_BUTTON (w)->active;
}

static void wm_decorations_clicked(GtkWidget *w, gpointer data)
{
	c_wm_decorations = GTK_TOGGLE_BUTTON (w)->active;
}

static void skin_item_selected(GtkWidget *clist, gint row, gint column,
		GdkEventButton *bevent, gpointer data)
{
	gchar *text = gtk_clist_get_row_data(GTK_CLIST(clist), row);
	if (text) gtk_entry_set_text(GTK_ENTRY(default_skin_entry),text);
}

static gint sort_skin_list_cb(void *a, void *b)
{
	gchar *fa = filename_from_path((gchar *)a);
	gchar *fb = filename_from_path((gchar *)b);
	if (!fa || !fb) return 0;
	return strcmp(fa, fb);
}

static GList *skin_list_add_dir(GList *list, gchar *skinpath)
{
	DIR *dp;
	struct dirent *dir;
	struct stat ent_sbuf;

	if((dp = opendir(skinpath))==NULL)
		{
		/* dir not found */
		return list;
		}

	while ((dir = readdir(dp)) != NULL)
		{
		/* skips removed files */
		if (dir->d_ino > 0)
			{
			gchar *name;
			gchar *path;

			name = dir->d_name; 
			if (strcmp(name, ".") == 0 || strcmp(name, "..") == 0) continue;

			path = g_strconcat(skinpath, "/", name, NULL);

			if (stat(path,&ent_sbuf) >= 0 && S_ISDIR(ent_sbuf.st_mode))
				{
				list = g_list_prepend(list, g_strdup(path));
				}
			g_free(path);
			}
		}
        closedir(dp);

	return list;
}

static void populate_skin_list(GtkWidget *clist)
{
	gchar *skinpath;
	GList *skin_list = NULL;
	GList *work;
	gchar *buf[2];
	gint row;

	/* add default skin */
	buf[0] = "None (default)";
	buf[1] = NULL;
	row = gtk_clist_append(GTK_CLIST(clist), buf);
	gtk_clist_set_row_data(GTK_CLIST(clist), row, "");

	/* add home dir skins */
	skinpath = g_strconcat(homedir(), "/", GQMPEG_RC_DIR_SKIN, NULL);
	skin_list = skin_list_add_dir(skin_list, skinpath);
	g_free(skinpath);

	/* add system dir skins */
	skinpath = g_strconcat(GQMPEG_GLOBAL_SKIN_DIR, NULL);
	skin_list = skin_list_add_dir(skin_list, skinpath);
	g_free(skinpath);

	skin_list = g_list_sort(skin_list, (GCompareFunc) sort_skin_list_cb);

	work = skin_list;
	while (work)
		{
		gchar *skindata_file = g_strconcat(work->data, "/skindata", NULL);
		if (isfile(skindata_file))
			{
			buf[0] = filename_from_path(work->data);
			row = gtk_clist_append(GTK_CLIST(clist),buf);
			gtk_clist_set_row_data_full(GTK_CLIST(clist), row,
					work->data, (GtkDestroyNotify) g_free);
			}
		else
			{
			g_free(skindata_file);
			skindata_file = g_strconcat(work->data, "/main.bmp", NULL);
			if (isfile(skindata_file))
				{
				gchar *amp_txt = g_strconcat (filename_from_path(work->data), " (amp)", NULL);
				buf[0] = amp_txt;
				row = gtk_clist_append(GTK_CLIST(clist),buf);
				gtk_clist_set_row_data_full(GTK_CLIST(clist), row,
						work->data, (GtkDestroyNotify) g_free);
				g_free(amp_txt);
				}
			else
				{
				gchar *name = work->data;
				printf("Valid skin not found in:%s\n", name);
				printf("File named skindata (gqmpeg skins) or main.bmp (winamp skins) not found.\n");
				g_free(work->data);
				}
			}
		g_free(skindata_file);
		work = work->next;
		}

	g_list_free(skin_list);
}

void show_about_info()
{
	if (!configwindow)
		create_config_window(6);
		gtk_widget_show(configwindow);
}

void show_configuration_window()
{
	if (configwindow)
		{
		gdk_window_raise(configwindow->window);
		return;
		}

	create_config_window(0);
	gtk_widget_show_all(configwindow);
}

static void hide_configuration_window()
{
	player_modules_config_close();
	gtk_widget_destroy(configwindow);
	configwindow = NULL;
}

static void ok_configuration_window()
{
	apply_configuration_window();
	hide_configuration_window();
}

static void apply_configuration_window()
{
	gchar *buf = NULL;
	gint i;
	gint skin_changed = FALSE;

	initial_playlist_mode = c_initial_playlist_mode;

	if (initial_playlist_pathname)
		{
		g_free(initial_playlist_pathname);
		initial_playlist_pathname = NULL;
		}
	buf = gtk_entry_get_text(GTK_ENTRY(initial_playlist_entry));
	if (buf&& strlen(buf) > 0) initial_playlist_pathname = g_strdup(buf);

	if ( double_size_mode != c_double_size_mode || 
		show_extra_winamp_info != c_show_extra_winamp_info) skin_changed = TRUE;

	double_size_mode = c_double_size_mode;
	show_extra_winamp_info = c_show_extra_winamp_info;

	buf = gtk_entry_get_text(GTK_ENTRY(default_skin_entry));
	if ( (buf && default_skin && strcmp(buf,default_skin) != 0 && strlen(buf) > 0) ||
		(!default_skin && buf && strlen(buf) > 0) || 
		(buf && strlen(buf) > 0 && skin_changed))
		{
		/* change to the new skin */
		change_to_skin(buf);
		}
	else if ((default_skin && buf && strlen(buf) == 0) || skin_changed)
		{
		change_to_skin(NULL);
		}
	g_free(default_skin);
	default_skin = NULL;
	if (buf && strlen(buf) > 0) default_skin = g_strdup(buf);

	if (mixer_device_id != c_mixer_device_id)
		set_mixer_device(c_mixer_device_id);
	mixer_device_id = c_mixer_device_id;

	if (mixer_command)
		{
		g_free(mixer_command);
		mixer_command = NULL;
		}
	buf = gtk_entry_get_text(GTK_ENTRY(mixer_entry));
	if (buf && strlen(buf) > 0) mixer_command = g_strdup(buf);

	start_playing_on_startup = c_start_playing_on_startup;
	show_playlist_on_startup = c_show_playlist_on_startup;

	obey_mode_in_playlist = c_obey_mode_in_playlist;

	smart_window_placement = c_smart_window_placement;
	remember_window_position = c_remember_window_position;
	wm_decorations = c_wm_decorations;

	play_presets = c_play_presets;
	drop_single_to_playlist = c_drop_single_to_playlist;

	if (playlist_accounting != c_playlist_accounting)
		{
		playlist_accounting = c_playlist_accounting;
		playlist_update_format_info();
		playlist_window_length_update();
		}

	if (read_header_tags != c_read_header_tags)
		{
		read_header_tags = c_read_header_tags;
		playlist_update_generic_info();
		}

	if (show_dot_files != c_show_dot_files || disable_filtering != c_disable_filtering)
		{
		show_dot_files = c_show_dot_files;
		disable_filtering = c_disable_filtering;
		filelist_refresh();
		}

	initial_directory_enable = c_initial_directory_enable;
	if (initial_directory_path)
		{
		g_free(initial_directory_path);
		initial_directory_path = NULL;
		}
	buf = remove_trailing_slash(gtk_entry_get_text(GTK_ENTRY(initial_directory_entry)));
	if (buf && strlen(buf) > 0) initial_directory_path = g_strdup(buf);
	g_free(buf);

	player_modules_config_apply();

	if (allow_ipc != c_allow_ipc)
		{
		allow_ipc = c_allow_ipc;
		if (allow_ipc)
			ipc_on();
		else
			ipc_off();
		}

	prev_includes_current = c_prev_includes_current;

	for (i=0; i<10; i++)
		{
		if (preset_name[i]) g_free(preset_name[i]);
		if (preset_file[i]) g_free(preset_file[i]);

		buf = gtk_entry_get_text(GTK_ENTRY(preset_name_entry[i]));
		if (strlen(buf) > 0)
			preset_name[i] = g_strdup(buf);
		else
			preset_name[i] = NULL;

		buf = gtk_entry_get_text(GTK_ENTRY(preset_file_entry[i]));
		if (strlen(buf) > 0)
			preset_file[i] = g_strdup(buf);
		else
			preset_file[i] = NULL;
		}

	create_preset_menu();
	gdk_window_set_decorations (mainwindow->window, wm_decorations);
}

static void create_config_window(gint start_tab)
{
	GtkWidget *configvbox;
	GtkWidget *configtabs;
	GtkWidget *radiobutton;
	GtkWidget *button;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *vbox1;
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *scrolled;
	GtkWidget *skin_clist;
	GtkWidget *table;
	GtkWidget *sep;

        GtkWidget *omenu;
        GtkWidget *menu;
        GtkWidget *item;
	GList *devices;
	GList *list;
	gint lh, cnt, i;

	GtkWidget *tabcomp;

	GtkWidget *about_icon;
	GdkPixmap *about_pixmap;
	GdkBitmap *about_mask;
	GtkStyle *style;

	gchar *skin_title [] = { "Available skins:", };
	gchar *skin_label_text;
	gchar infostr[255];

	GtkWidget *playertabs;
	GList *player_list;
	GList *work;

	configwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (configwindow), "delete_event",(GtkSignalFunc) hide_configuration_window, NULL);
	gtk_window_set_policy (GTK_WINDOW (configwindow), FALSE, FALSE, TRUE);
	gtk_window_set_title (GTK_WINDOW (configwindow), "GQmpeg configuration");
	gtk_container_border_width (GTK_CONTAINER (configwindow), 5);

	configvbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(configwindow),configvbox);
	gtk_widget_show(configvbox);

	hbox = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_end(GTK_BOX(configvbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("Ok");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) ok_configuration_window, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 20);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Apply");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) apply_configuration_window, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 20);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) hide_configuration_window, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 20);
	gtk_widget_show(button);

	configtabs = gtk_notebook_new();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK(configtabs), GTK_POS_TOP);
	gtk_box_pack_start (GTK_BOX(configvbox), configtabs, TRUE, TRUE, 0);

	/* general tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("General");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);
	
	frame = gtk_frame_new("Song Information");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	c_playlist_accounting = playlist_accounting;
	button = gtk_check_button_new_with_label ("Read file headers (enables playlist length calculation)");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_playlist_accounting);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) playlist_accounting_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_read_header_tags = read_header_tags;
	button = gtk_check_button_new_with_label ("Use ID3 tags when available");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_read_header_tags);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) header_tags_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	frame = gtk_frame_new("Window");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	c_smart_window_placement = smart_window_placement;
	button = gtk_check_button_new_with_label ("Smart window placement");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_smart_window_placement);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) window_placement_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_remember_window_position = remember_window_position;
	button = gtk_check_button_new_with_label ("Remember window position");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_remember_window_position);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) window_position_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_wm_decorations = wm_decorations;
	button = gtk_check_button_new_with_label ("Enable window manager decorations");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_wm_decorations);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) wm_decorations_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_double_size_mode = double_size_mode;
	button = gtk_check_button_new_with_label ("Double sized window");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_double_size_mode);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) double_size_mode_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	frame = gtk_frame_new("Mixer");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("External Mixer:");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	gtk_widget_realize(configwindow);

	tabcomp = tab_completion_new(&mixer_entry, configwindow, mixer_command, NULL, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), tabcomp,TRUE,TRUE,5);
	gtk_widget_show(tabcomp);

	c_mixer_device_id = mixer_device_id;
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("Volume controls device:");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

        omenu = gtk_option_menu_new ();
        menu = gtk_menu_new ();

	devices = get_mixer_device_list();

	list = devices;

	cnt = 0;
	while(list)
		{
		gchar *dev_text = list->data;
	        item = gtk_menu_item_new_with_label(dev_text);
	        gtk_signal_connect (GTK_OBJECT (item), "activate", (GtkSignalFunc) mixer_device_id_cb, dev_text);
        	gtk_menu_append (GTK_MENU (menu), item);
		if (get_mixer_device_id(dev_text) == mixer_device_id) lh = cnt;
		cnt++;
		list = list->next;
		}

	g_list_free(devices);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (omenu), lh);
        gtk_box_pack_start( GTK_BOX(hbox), omenu, TRUE, TRUE, 5);
        gtk_widget_show (omenu);

	c_prev_includes_current = prev_includes_current;
	button = gtk_check_button_new_with_label ("First press of prev restarts song when playing");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_prev_includes_current);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) prev_includes_current_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_allow_ipc = allow_ipc;
	button = gtk_check_button_new_with_label ("Allow command parsing through ~/.gqmpeg/command");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_allow_ipc);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) allow_ipc_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	/* Startup tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Startup");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);
	
	frame = gtk_frame_new("Initial playlist");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	c_initial_playlist_mode = initial_playlist_mode;
	radiobutton = gtk_radio_button_new_with_label (NULL,"Empty");
	if (c_initial_playlist_mode == PLAYLIST_MODE_EMPTY) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radiobutton), 1);
	gtk_signal_connect (GTK_OBJECT(radiobutton),"clicked",(GtkSignalFunc) initial_playlist_empty_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), radiobutton, FALSE, FALSE, 0);
	gtk_widget_show(radiobutton);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton)),"Save playlist between sessions");
	if (c_initial_playlist_mode == PLAYLIST_MODE_SESSION) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) initial_playlist_session_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton)),"Open specific playlist:");
	if (c_initial_playlist_mode == PLAYLIST_MODE_FILE) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) initial_playlist_file_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	tabcomp = tab_completion_new(&initial_playlist_entry, configwindow, initial_playlist_pathname, NULL, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), tabcomp,TRUE,TRUE,0);
	gtk_widget_show(tabcomp);

	button = gtk_button_new_with_label("Use current");
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc)set_current_playlist_clicked, NULL);
	gtk_box_pack_end(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_widget_show(button);

	frame = gtk_frame_new("When program starts:");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	c_start_playing_on_startup = start_playing_on_startup;
	button = gtk_check_button_new_with_label ("Start playing");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_start_playing_on_startup);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) start_playing_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_show_playlist_on_startup = show_playlist_on_startup;
	button = gtk_check_button_new_with_label ("Show playlist window");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_show_playlist_on_startup);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) show_playlist_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_initial_directory_enable = initial_directory_enable;
	button = gtk_check_button_new_with_label ("Change to this directory:");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_initial_directory_enable);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) initial_directory_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	tabcomp = tab_completion_new(&initial_directory_entry, configwindow, initial_directory_path, NULL, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), tabcomp,TRUE,TRUE,0);
	gtk_widget_show(tabcomp);

	button = gtk_button_new_with_label("Use current");
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc)set_current_dir_clicked, NULL);
	gtk_box_pack_end(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_widget_show(button);

	/* output player tab */
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type (GTK_FRAME(frame), GTK_SHADOW_NONE);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Output");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	playertabs = gtk_notebook_new();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK(playertabs), GTK_POS_TOP);
	gtk_container_add(GTK_CONTAINER(frame), playertabs);
	gtk_widget_show(playertabs);

	player_list = player_modules_config_init();
	work = player_list;
	while (work)
		{
		GtkWidget *w = work->data;
		GtkWidget *wlabel;
		gchar *wtext = gtk_object_get_user_data(GTK_OBJECT(w));

		wlabel = gtk_label_new(wtext);
		gtk_notebook_append_page (GTK_NOTEBOOK (playertabs), w, wlabel);
		gtk_widget_show(w);
		work = work->next;
		}

	if (player_list) g_list_free(player_list);

	/* playlist tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Playlist");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	c_obey_mode_in_playlist = obey_mode_in_playlist;
	button = gtk_check_button_new_with_label ("Obey shuffle / repeat if saved in playlist");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_obey_mode_in_playlist);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) obey_playlist_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_show_dot_files = show_dot_files;
	button = gtk_check_button_new_with_label ("Show hidden files and directories in playlist window");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_show_dot_files);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) hidden_files_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_disable_filtering = disable_filtering;
	button = gtk_check_button_new_with_label ("Show all files in the playlist window");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_disable_filtering);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_files_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_drop_single_to_playlist = drop_single_to_playlist;
	button = gtk_check_button_new_with_label ("Add single item drops on main window to playlist");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_drop_single_to_playlist);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) drop_single_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	/* preset tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Presets");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	table=gtk_table_new(3,11,FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);
        gtk_widget_show(table);

	label = gtk_label_new("#");
        gtk_table_attach_defaults(GTK_TABLE (table),label, 0, 1, 0, 1);
        gtk_widget_show(label);
        label = gtk_label_new("Preset name");
        gtk_table_attach_defaults(GTK_TABLE (table),label, 1, 2, 0, 1);
        gtk_widget_show(label);
        label = gtk_label_new("Playlist file");
        gtk_table_attach_defaults(GTK_TABLE (table),label, 2, 3, 0, 1);
        gtk_widget_show(label);

	for (i=0; i<10; i++)
		{
		gchar s[16];
		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
		gtk_widget_show(hbox);

		sprintf(s,"%d",i + 1);
                label = gtk_label_new(s);
		gtk_table_attach_defaults(GTK_TABLE (table),label,0,1,i+1,i+2);
		gtk_widget_show(label);

		preset_name_entry[i] = gtk_entry_new_with_max_length(32);
                gtk_widget_set_usize(preset_name_entry[i],80,-1);
		if (preset_name[i]) gtk_entry_set_text(GTK_ENTRY(preset_name_entry[i]), preset_name[i]);
		gtk_table_attach_defaults(GTK_TABLE (table),preset_name_entry[i],1,2,i+1,i+2);
                gtk_widget_show(preset_name_entry[i]);

		tabcomp = tab_completion_new(&preset_file_entry[i], configwindow, preset_file[i], NULL, NULL);
		gtk_table_attach_defaults(GTK_TABLE (table), tabcomp,2,3,i+1,i+2);
                gtk_widget_show(tabcomp);
		}

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	c_play_presets = play_presets;
	button = gtk_check_button_new_with_label ("Play presets immediately");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_play_presets);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) play_presets_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	/* skin tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Skins");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("Skin:");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
	gtk_widget_show (label);

	default_skin_entry = gtk_entry_new_with_max_length(511);
	if (default_skin)
		gtk_entry_set_text(GTK_ENTRY(default_skin_entry),default_skin);
	gtk_box_pack_start(GTK_BOX(hbox),default_skin_entry,TRUE,TRUE,0);
	gtk_widget_show(default_skin_entry);

	scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled,TRUE,TRUE,0);
	gtk_widget_show(scrolled);

	/* skin list */
	skin_clist=gtk_clist_new_with_titles (1, skin_title);
	gtk_clist_column_titles_passive (GTK_CLIST (skin_clist)); 
	gtk_signal_connect (GTK_OBJECT (skin_clist), "select_row",(GtkSignalFunc) skin_item_selected, NULL);
	gtk_container_add (GTK_CONTAINER (scrolled), skin_clist);
	gtk_widget_show (skin_clist);

	populate_skin_list(skin_clist);

	skin_label_text = g_strconcat(homedir(), "/", GQMPEG_RC_DIR_SKIN, NULL);

	label = gtk_label_new(skin_label_text);
	gtk_box_pack_end(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	g_free(skin_label_text);

	c_show_extra_winamp_info = show_extra_winamp_info;
	button = gtk_check_button_new_with_label ("Display cpu and frame information in amp skins");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_show_extra_winamp_info);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) show_extra_winamp_info_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);
	gtk_widget_show(sep);

	label = gtk_label_new("Please place custom skins in:");
	gtk_box_pack_end(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	/* about tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("About");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	label = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	gtk_widget_realize(configwindow);

	style = gtk_widget_get_style(configwindow);
	about_pixmap = gdk_pixmap_create_from_xpm_d(configwindow->window, &about_mask,
		&style->bg[GTK_STATE_NORMAL], (gchar **)gqmpeg_icon_xpm);
	about_icon = gtk_pixmap_new(about_pixmap, about_mask);
	gtk_box_pack_start(GTK_BOX(vbox), about_icon, FALSE, FALSE, 0);
	gtk_widget_show(about_icon);

	sprintf(infostr,"GQmpeg %d.%d.%d\nA frontend to mpg123\n\nCopyright (c) 1998, 1999 by John Ellis\nhttp://gqview.netpedia.net\ngqview@email.com\n\nReleased under the GNU Public License",GQMPEG_VERSION_MAJOR,GQMPEG_VERSION_MINOR,GQMPEG_VERSION_REV);
	label = gtk_label_new(infostr);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	label = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	gtk_notebook_set_page (GTK_NOTEBOOK(configtabs), start_tab);
	gtk_widget_show(configtabs);

}


