/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Galeon includes */
#include "galeon.h"
#include "Gtm.h"

/* GNOME includes */
#include <libgnorba/gnorba.h>

/*
 * Calls the gtm CORBA interface function gtm_add_url() to place the
 * download in queue
 */
gboolean gtm_add_url (const gchar *url, gchar *dir, gboolean disable_proxy,
		      gboolean disable_auto_dl)
{
	CORBA_Environment ev;
	GTM_Download gtm_download_client;
	gboolean result;

	result = FALSE;
	gtm_download_client = 
	goad_server_activate_with_repo_id (	NULL,
						"IDL:gtm/download:1.0", 0,
						NULL);

	if (gtm_download_client != NULL)
	{
		CORBA_exception_init (&ev);
		result = GTM_Download_add_url ( gtm_download_client, url, dir,
						disable_proxy,
						disable_auto_dl, &ev);
		
		if (ev._major != CORBA_NO_EXCEPTION)
		{
			g_warning ("Exception thrown: %s\n", CORBA_exception_id (&ev));
			CORBA_exception_free (&ev);
		}
	}
	else
	{
		g_warning(_("unable to download using GTM -- please check if installed?"));
	}
  
	return result;
}
