/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

/* how often to save the history, in milliseconds */
#define HISTORY_SAVE_INTERVAL (60 * 5 * 1000)

/* history.c */
void history_init (void);
void history_exit (void);
void history_save (void);
void history_clear (void);
void history_visited (const gchar *url);
void history_set_page_title (const gchar *url, const gchar *title);
gboolean history_is_visited (const gchar *url);
const gchar *history_get_last_url (void);
GList *history_get_host_list (void);
void history_set_zoom (const gchar *url, gint zoom);
gint history_get_zoom (const gchar *url);
void history_show_dialog (GaleonWindow *window);
void history_hide_dialog (HistoryView *hv);
void history_show_dock (GaleonWindow *window);
void history_resort_view (HistoryView *hv);
void history_refresh_view (HistoryView *hv);
void history_destroy_view (HistoryView *hv);
void history_clear_recent_menu (void);

/* history_callbacks.c */
gint history_popup_selection_done_cb (GtkWidget *menushell,
				      GtkWidget *popup);
void history_time_optionmenu_deactivate_cb (GtkWidget *menushell,
					    HistoryView *hv);
gint history_compare_title_cb (gconstpointer a, gconstpointer b);
gint history_compare_url_cb (gconstpointer a, gconstpointer b);
gint history_compare_last_cb (gconstpointer a, gconstpointer b);
gint history_compare_first_cb (gconstpointer a, gconstpointer b);
gint history_compare_visits_cb (gconstpointer a, gconstpointer b);
gboolean history_periodic_save_cb (gpointer data);

#ifdef __cplusplus
}
#endif
