/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "mime.h"
#include "misc.h"

#include <string.h>

/* the global list of MimeItems */
GList *mime_types = NULL;

MimeAction 
mime_get_action (const gchar *mime_type)
{
	GList *l;
	for (l = mime_types; l != NULL; l = l->next)
		if (!strcmp (mime_type, ((MimeItem *) l->data)->name))
			return ((MimeItem *) l->data)->action;
	return MIME_UNKNOWN;
}

void 
mime_set_action (const gchar *mime_type, MimeAction action)
{
	GList *l;
	MimeItem *newitem;
	gboolean exists = FALSE;

	/* change the value if we already have it in the list */
	for (l = mime_types; l != NULL; l = l->next)
		if (!strcmp (mime_type, ((MimeItem *) l->data)->name))
		{
			exists = TRUE;
			((MimeItem *) l->data)->action = action;
		};
	/* not found, add a new mime type */
	if (!exists)
	{
		newitem = g_new0 (MimeItem, 1);
		newitem->name = g_strdup (mime_type);
		newitem->action = action;
		mime_types = g_list_prepend (mime_types, newitem);
	};
}
	
MimeItem *
mime_item_clone (MimeItem *m)
{
	MimeItem *r = g_new0 (MimeItem, 1);
	g_return_val_if_fail (m != NULL, NULL);	
	g_return_val_if_fail (m->name != NULL, NULL);
	r->name = g_strdup (m->name);
	r->action = m->action;
	return r;
}

void
mime_item_free (MimeItem *m)
{
	if (m->name) g_free (m->name);
	g_free (m);
}
