enum node_type;

/* different kinds of things that can appear in the value field
   of a hash node.  Actually, this may be useless now. */
union hashval
{
   int                 ival;
   char               *cpval;
   DEFINITION         *defn;
};

struct hashnode
{
   struct hashnode    *next;	/* double links for easy deletion */
   struct hashnode    *prev;
   struct hashnode   **bucket_hdr;	/* also, a back pointer to this node's hash
					 * chain is kept, in case the node is the head
					 * of the chain and gets deleted. */
   enum node_type      type;	/* type of special token */
   int                 length;	/* length of token, for quick comparison */
   unsigned char      *name;	/* the actual name */
   union hashval       value;	/* pointer to expansion, or whatever */
};

typedef struct hashnode HASHNODE;

/* Some definitions for the hash table.  The hash function MUST be
   computed as shown in hashf () below.  That is because the rescan
   loop computes the hash value `on the fly' for most tokens,
   in order to avoid the overhead of a lot of procedure calls to
   the hashf () function.  Hashf () only exists for the sake of
   politeness, for use when speed isn't so important. */

#define HASHSIZE 1403
#define HASHSTEP(old, c) ((old << 2) + c)
#define MAKE_POS(v) (v & 0x7fffffff)	/* make number positive */

extern HASHNODE    *install
PARAMS((unsigned char *, int, enum node_type, int, char *, int));
