//////////////////////////////////////////////////////////////         
//      $Id: findf.cpp,v 1.16 2001/01/23 18:48:06 matz Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"

#include "kpackage.h"
#include "pkgInterface.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "findf.h"
#include "options.h"
#include <klocale.h>
#include <qlineedit.h>
#include <qdragobject.h>

extern pkgInterface *kpinterface[];
extern Opts *opts;

FindF::FindF(QWidget *parent)
    : QDialog(parent, 0,FALSE){

    this->setFocusPolicy(QWidget::StrongFocus);

    QVBoxLayout* vtop = new QVBoxLayout( this, 20, 10, "vtop");

    frame1 = new QGroupBox(i18n("Find File"), this, "frame1");
    vtop->addWidget(frame1,4);
    QVBoxLayout* vf = new QVBoxLayout( frame1, 12, 10, "vf");

    value = new QLineEdit( frame1, "value");
    vf->addWidget(value,1);
    value->setFocus();

    connect(value, SIGNAL(returnPressed()), this, SLOT(ok_slot()));

    tab = new KListView(frame1,"tab");
    connect(tab, SIGNAL(selectionChanged ( QListViewItem * )),
	    this, SLOT(search( QListViewItem * )));
    tab->addColumn(i18n("Type"),40);
    tab->addColumn(i18n("Package"),120);
    tab->addColumn(i18n("File Name"),300);
    tab->setAllColumnsShowFocus(TRUE);
    tab->setSorting(1);
    vf->addWidget(tab,4);

    QHBoxLayout* hb = new QHBoxLayout( );
    vtop->addLayout(hb,0);

    ok = new QPushButton(i18n("Find"), this, "find");
    hb->addWidget(ok,1,AlignLeft);

    connect(ok, SIGNAL(clicked()), this, SLOT(ok_slot()));
    
    hb->addStretch();

    cancel = new QPushButton(i18n("Done"), this, "cancel");
    hb->addWidget(cancel,1,AlignRight);

    connect(cancel, SIGNAL(clicked()), this, SLOT(done_slot()));
 
    show();

    setAcceptDrops(true);
}

FindF::~FindF()
{
}

void FindF::ok_slot() 
{
  doFind(this->value->text());
}

void FindF::doFind(const QString &str) 
{
  QString s, tmp;
  QString t;
  int i, cnt = 0;;

  tab->clear();

  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i] && opts->handlePackage[i]) {
      s = kpinterface[i]->FindFile(str);

      if (s.length() > 0) {
	cnt++;
	int p = 0, pp = 0;
	while ((p = s.find('\n',p)) >= 0) {
	  t = kpinterface[i]->head;
	  tmp = s.mid(pp,p - pp);
	  if (tmp.find("diversion by") >= 0) {
	    new QListViewItem(tab, "", tmp);
	  }

	  int t1 = tmp.find('\t');
	  QString s1 = tmp.left(t1);
	  QString s2 = tmp.right(tmp.length()-t1);

	  new QListViewItem(tab, t, s1, s2);
	  p++;
	  pp = p;
	}
      }
    }
  }

  if (!cnt) {
    new QListViewItem(tab, "", i18n("--Nothing found--"));
  }
}

void FindF::done_slot()
{
  this->hide();
}

void FindF::resizeEvent(QResizeEvent *){
}

void FindF::search(QListViewItem *item)
{
  int p;
  QString s = item->text(1);
  kdDebug() << "searchF=" << s << "\n";

  p = s.find(',');
  if (p > 0) {
    s.truncate(p);
  }
 KPLVItem *k =  kpackage->management->search(s ,item->text(0));
 if (k)
   kpackage->management->changePack(k);
}

void FindF::dragEnterEvent(QDragEnterEvent* e)
{
  e->accept(QUriDrag::canDecode(e));
}

void FindF::dropEvent(QDropEvent *de) // something has been dropped
{
  QStrList list;
  QUriDrag::decode(de, list);
  QString url;

  const char *s = list.first();
  KURL *u = new KURL( s );

  if (!u->isMalformed() && (u->protocol() == "file"  )) {
    url = u->path();
    if (url.right(1) == "/")
      url.truncate(url.length()-1);
    value->setText(url);
    doFind(url);
  } else {
    KpMsgE(i18n("Incorrect URL type"),FALSE);
  }
}
