//////////////////////////////////////////////////////////////////////
//      $Id: kpPty.cpp,v 1.14 2001/02/06 15:43:53 toivo Exp $ 
// File  : kpackage.cpp
// Author: Toivo Pedaste
// 
//////////////////////////////////////////////////////////////////////

#include "../config.h"

#include <kpPty.h>
#include <kpackage.h>
#include <kpTerm.h>
#include <options.h>

extern Opts *opts;   
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

kpPty::kpPty() : QObject()
{
  //  kdDebug() << "kpPty::kpPty\n";
  pty = new TEPty();
  connect(pty, SIGNAL(block_in(const char*,int)), this,
		   SLOT(block_in(const char*,int)));
  connect(pty, SIGNAL(done(int)), this,
		   SLOT(done(int)));
  pty->setSize(0,80);
  tm = new QTimer(this);
  connect(tm, SIGNAL(timeout()), this, SLOT(slotTimeout()));

  eventLoop = FALSE;
  started = FALSE;
  pUnterm = FALSE;
}


kpPty::~kpPty()
{
}

bool kpPty::start(bool needRoot)
{
  kdDebug() << "kpPty::start\n";
  pUnterm = FALSE;

  if (!started && (!remote.isEmpty() || !(getuid() == 0 || !needRoot))) {
    int ret;
    QStrList cs;
    QString s = "echo START=$?\n";
    terminator.setPattern("START=\\d+");

    retList.clear();

    if (opts->useSSH || !remote.isEmpty()) {
      kdDebug() << "/usr/bin/ssh\n";
      cs.append("/usr/bin/ssh");
      cs.append("-l");
      cs.append("root");
      if (remote.isEmpty()) {
	cs.append("localhost");
      } else {
	cs.append(remote.local8Bit());
      }
      pty->run("/usr/bin/ssh",cs,"dumb",FALSE);
    } else {
      kdDebug() << "su\n";
      cs.append("su");
      pty->run("su",cs,"dumb",FALSE);
    }

    timeout = FALSE;
    tm->start(3*1000, TRUE); 
    eventLoop = TRUE;
    kdDebug() << "Loopst\n";
    kapp->enter_loop();
    kdDebug() << "Loopfn\n";
    tm->stop();
    if (timeout) {
      //      kdDebug() << "Start " << retList.count() <<" \n";
      kpstart->addText(retList);
      kpstart->run("", i18n("ROOT Login: This assumes root prompt ends with '# '"));
      ret = kpstart->exec();
      kdDebug() << "Sret=" << ret << "\n";
      if (ret) {
	started = FALSE;
      } else {
	started = TRUE;
      }
    } else {
      started = TRUE;
    }
    return started;
  }
  return TRUE;
}


QStringList kpPty::run(QString cmd, bool inLoop, bool needRoot)
{

  terminator.setPattern("RESULT=\\d+");
  pUnterm = FALSE;

  if (remote.isEmpty() && !started && (getuid() == 0 || !needRoot)) {
    kdDebug() << "rRUN="<< cmd <<"\n";
    QStringList cl = QStringList::split(" ", cmd);
    QStrList cs;
    for ( QStringList::Iterator it = cl.begin(); it != cl.end(); ++it ) {
      cs.append((*it).latin1());
    }
    int res = pty->run(cs.first(),cs,"dumb",FALSE);
    kdDebug() << "res="<< res <<"\n";
  } else {
    if (start(needRoot)) {
      kdDebug() << "iRUN="<< cmd <<"\n";
      QString s = cmd + ";echo RESULT=$?\n";
      pty->send_bytes(s.ascii(),s.length());
    } else {
      return 0;
    }
  }

  retList.clear();

  if (inLoop) {
    eventLoop = TRUE;
    kapp->enter_loop();

    kdDebug() << "R=" << retList.count() <<"\n";
    
    return retList;
  } else {
    return 0;
  }
}

void kpPty::finish(int ret)
{
  //  int num = retList.count();

  if (ret == -1) {
    QStringList::Iterator l = retList.fromLast();
    l--;
    kdDebug() << "r=" << *l <<  "=\n";
    int p;
    if ((p = (*l).find("RESULT=")) >= 0) {
      ret = (*l).mid(p+7).toInt(0,10);
      //	 kdDebug() << "Ret=" << ret << "=" <<  (*l).mid(p+7) << ":" << num <<"\n";
      //      kdDebug() << "R=" << *l << "\n";
      retList.remove(l);                  // Remove return code
    } else {
      //      kdDebug() << "RR=" << *l << "\n";
      ret = 666;
    }
	
    l = retList.fromLast();
    if ((*l).right(2) == "# ") {
      retList.remove(l);                  // Remove prompt
    }
  }
  kdDebug() << "Ret=" << ret << "\n";
  emit result(retList,ret);

  if (eventLoop) {
    eventLoop = FALSE;
    kapp->exit_loop();
  }
}

void kpPty::block_in(const char* txt, int len)
{
  bool unterm = FALSE;
  //  kdDebug() << "L=" << len << "\n";

  if (len < 0) len = 0;
  QCString text( txt, len+1 );
  text[len] = 0;
  if (text[len-1] != '\n') {
    unterm = TRUE;
  }

  QString stext =  QString::fromLocal8Bit(text);

  emit textIn(stext);

  QStringList sl = QStringList::split("\r\n",stext,TRUE);
  //  kdDebug() << "L=" << stext.length() << ":" <<sl.count() << " " << pUnterm << "\n";

  if (sl.count() > 0) {
    QStringList::Iterator l = sl.fromLast();
    if ((*l).isEmpty()) {
      //      kdDebug() << "removeLast:" << *l << "\n";
      sl.remove(l);
    }
  }

  if (sl.count() > 0) {
    if (pUnterm) {

      QStringList::Iterator lst =  retList.fromLast();
      QStringList::Iterator fst =  sl.begin();

      //      kdDebug() << "BBrk=" << (*lst) << "=" << (*fst) << "\n";

      if ((*lst).right(1) == "\r" && (*fst).left(1) == "\n") {
	// handle /r/n split between blocks
	(*lst).truncate((*lst).length() - 1);
	(*fst) = (*fst).mid(1);
      } else {
	if ((*fst).left(1) != "\r") {
	  (*lst) = (*lst) + (*fst);
	} else {
	  // Remove line that is overwritten on screen
	  //	  kdDebug() << "ERASE=[" << *fst << "]\n";
	}
	sl.remove(fst);
      }
      //            kdDebug() << "PU=" << stext.length() << ":" <<sl.count() << "\n";
    }

    //    kdDebug() << "s=[" << text << "]\n";
    
    for ( QStringList::Iterator it = sl.begin(); it != sl.end(); ++it ) {
      retList << (*it);
    }
  }
  pUnterm = unterm;

  if (stext.right(2) == "# ") {
    emit textIn("\r \n");
    finish(-1);
  }
}

void kpPty::keyOut(char ch)
{
  pty->send_byte(ch);
}

void kpPty::done(int ret)
{
  kdDebug() << "Done\n";

  finish(ret);
}

void kpPty::slotTimeout()
{
  kdDebug() << "Timeout..............\n";
  if (eventLoop) {
    timeout = TRUE;
    eventLoop = FALSE;
    kapp->exit_loop();
  }
}
