/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>
#include <kdebug.h>

#include "conflict.h"


/*
 * Public methods
 *****************/
 
QString  Conflict::description()
{ 
  QString  numstr;
  QString  desc  = _resource->resourceUpperName();
  ulong    value = _resource->resourceValue();
  ulong    range = _resource->resourceRange();
  
  switch (_resource->resourceType())
  {
    case Resource::ResDMAPort    : // fall through
    case Resource::ResInterrupt  : numstr.setNum(value);
                                   numstr = ' '+numstr+' ';
    		                   break;
    case Resource::ResIOAddress  : numstr.sprintf(" %04x-%04x ", value, value+range-1);
    		                   break;
    case Resource::ResMemAddress : numstr.sprintf(" %08x-%08x ", value, value+range-1);
    default                      : numstr = "";
  }
  
  desc += numstr+i18n("used by:")+"\n   "+_device->deviceName();
  
  kdDebug() << "CONFLICT REPORT: " << desc << endl;
  return desc;
}

