/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qdir.h>

#include "cputypescanner.h"


CpuTypeScanner::CpuTypeScanner() 
{
  _cpucount = 0;
}


/*
 * Public methods
 *****************/
 
Device  *CpuTypeScanner::firstDevice()
{ 
  return nextDevice();
}

 
Device  *CpuTypeScanner::nextDevice()
{
  CpuType  *dev;

  dev = device();
  return dev;
}

 
/* 
 * Private methods
 ******************/
 
CpuType *CpuTypeScanner::device()
{
  char       buffer[256];
  QString 	 vendor, model,value, mhzstr;
  uint		 count = 0;
  int 		 pos = -1, mhzint;
  float		 mhz;
  CpuType    *cputype = 0L;
  FILE *fhd;

  if ((fhd = fopen("/proc/cpuinfo", "r")))
  {
    while (fgets(buffer, sizeof(buffer), fhd))
    {
      value = QString(buffer);
      if (value.find("vendor_id") >= 0) 
      {
      		pos   = value.find(':');

	  		value = value.right(value.length()-pos-1);
      		value = value.stripWhiteSpace();

 			vendor = value;
      }
	  else if (value.find("model name") >= 0) 
	  {
            pos   = value.find(':');
 
            value = value.right(value.length()-pos-1);
            value = value.stripWhiteSpace();
 
            model = value;
	  }
      else if (value.find("cpu MHz") >= 0)
      {
      		pos    = value.find(':');
      		value  = value.right(value.length()-pos-1);
      		value  = value.stripWhiteSpace();
 
      		mhz    = value.toFloat();
      		mhzint = (int) mhz;
 
      		if (mhzint % 10 == 8) mhzint += 2;
      		if (mhzint % 10 == 9) mhzint += 1;
 
      		mhzstr.setNum(mhzint);
 
      		mhzstr   += " MHz"; 
			count++;
      }
	  if ( count > _cpucount) {
			fclose(fhd);
			cputype = new CpuType(vendor,model,mhzstr,_cpucount);
			_cpucount++;
    		return cputype;
	  }
	}
  }
  fclose(fhd);
  return 0;
}
 
 
 
