/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __DRIVEINFO_H
#define __DRIVEINFO_H

#include <qlist.h>
#include <qstring.h>

#include "partitioninfo.h"


class DriveInfo
{
  public:
  
    enum drivetype { DriveNone,
    		     DriveCDROM,
                     DriveHD };
  
    DriveInfo(const QString& deviceid, drivetype);
    ~DriveInfo() {}

    ulong          blocks() const    { return _blocks;                    }
    int            count()  const    { return _partlist.count();          }
    QString        device() const    { return QString("/dev/")+_deviceid; }
    
    PartitionInfo  *firstPartition() { return _partlist.first(); }
    PartitionInfo  *nextPartition()  { return _partlist.next();  }    
    
  private:
  
    QString  readSizes(const QString& partid, ulong *total, ulong *used, ulong *avail); 
  
    QString               _deviceid;
    QList<PartitionInfo>  _partlist;

    ushort                _major, _minor;
    ulong                 _blocks;
};


#endif
