/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __DRIVER_H
#define __DRIVER_H

#include <qdatetime.h>
#include <qstring.h>


class Driver
{
  public:
  
    Driver(const QString& name, const QString& release, 
    	   const QString& vendor, const QDate& reldate);
           
    ~Driver() {}
    
    QString  name()        const { return _name;    }
    QString  release()     const { return _release; }
    QString  vendor()      const { return _vendor;  }
    QDate    releaseDate() const { return _reldate; }
    
  protected:
  
    QString  _name,   _release;
    QString  _vendor;
    QDate    _reldate;
};


#endif

