/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qdir.h>

#include "memorytypescanner.h"


MemoryTypeScanner::MemoryTypeScanner()
{

}


/*
 * Public methods
 *****************/

Device  *MemoryTypeScanner::firstDevice()
{
  MemoryType  *dev;

  dev = device();
  return dev;
	
}


Device  *MemoryTypeScanner::nextDevice()
{
  return 0L;
}


/*
 * Private methods
 ******************/

MemoryType *MemoryTypeScanner::device()
{
  char       buffer[256];
  QString 	 value;
  int 		 pos = -1;
  ulong 		 size = 0;
  MemoryType    *memorytype = 0L;
  FILE *fhd;

  if ((fhd = fopen("/proc/meminfo", "r")))
  {
    while (fgets(buffer, sizeof(buffer), fhd))
    {
      value = QString(buffer);
      if ((pos = value.find("Mem:")) >= 0)
      {
	  		if (pos >= 0) {
				value = value.right(value.length()-4);
      			value = value.stripWhiteSpace();
				if ((pos = value.find(' ')) >= 0){
					value.truncate(pos);
					if ((size = value.toULong()))
					{
						size += 8388607;
						size /= (8*1024*1024);
						size *= 8;
					} 
				}
			}
	  }
	  if ( size > 0 ) {
                fclose(fhd);
                memorytype = new MemoryType(size);
                return memorytype;
     }
  	} 
  }
  fclose(fhd);
  return 0;
}



