/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __PROPRESTAB_H
#define __PROPRESTAB_H

#include <qcombobox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qwidget.h>

#include "conflictdisplay.h"
#include "devicelist.h"
#include "devtitle.h"
#include "resbaseconf.h"


class ResourcePropertiesTab : public QWidget
{
  Q_OBJECT
  
  public:
  
    ResourcePropertiesTab(Device *, QWidget *parent = 0L, const char *name = 0L);                         
    ~ResourcePropertiesTab() {}

    QList<Resource>&  resourceList() { return _reslist; }

  private:
  
    DeviceTitle         *_devtitle;
    QLabel              *_baselabel;
    QComboBox           *_basecombo;
    QListView           *_listview;
    QPushButton	        *_changebut;
    ConflictDisplay     *_conflictdisplay;
 
    QPixmap             _resxpm, _confxpm;  
 
    QList<Resource>     _reslist;
    Device              *_device;
    bool                _rootperm;
    ResourceBaseConfig  *_baseconf;
    
    QList<Conflict>  checkForConflicts();
    void             fillInConfigurations();
    void             fillInResources();
    
  private slots:

    void             slotChangeResource();
    void             slotConfigChanged(int);
    void             slotCurrentChanged(QListViewItem *);
};


#endif
