/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __RESOURCESPINBOX_H
#define __RESOURCESPINBOX_H

#include <qspinbox.h>
#include <qstring.h>

#include "resourcelist.h"


class ResourceSpinBox : public QSpinBox
{
  public:
  
    ResourceSpinBox(ResourceList *, int rescount, Resource *,
                    QWidget *parent = 0L, const char *name = 0L);  
                      
    ~ResourceSpinBox() {}
    
    int       initialValue() const { return _initial; }
    Resource  *resource(int);
    
  protected:
  
    virtual int      mapTextToValue(bool *ok);
    virtual QString  mapValueToText(int);
    
  private:
  
    ResourceList  *_reslist;
    Resource      *_setting;
    int           _initial;
    
    bool  isHex(const char *text, ulong *value);
    bool  isHexRange(const QString & text, ulong *fromval, ulong *range);    
    bool  isNumeric(const char *text, ulong *value);
};


#endif

