#include "NewClass.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>
#include <qtooltip.h>
#include <kmessagebox.h>

NewClass::NewClass(QWidget * parent, char * wname): QWidget(parent, wname)
{
	int y;
	this->setCaption(i18n("Add new user class"));
	resize(320,130);
	setFixedSize(320,130);
	QLabel *lbl1=new QLabel(i18n("New class &name:"), this);
	name=new QLineEdit(this);
	QToolTip::add(lbl1,i18n("The name of your new user class -\nmay be anything, but may not contain whitespaces."));
	QToolTip::add(name,i18n("The name of your new user class -\nmay be anything, but may not contain whitespaces."));
	lbl1->setBuddy(name);
	lbl1->move(0,0);
	name->setGeometry(lbl1->width(),0,320-lbl1->width(),name->height());
	y=name->height()+5;
	anon=new QCheckBox(i18n("&Anonymous"), this);
	anon->move(0,y);
	QToolTip::add(anon,i18n("Anonymous users\n(login=ftp or anonymous)"));
	guest=new QCheckBox(i18n("&Guest"), this);
	guest->move(width()/3,y);
	QToolTip::add(guest,i18n("Guest users\n(chrooted real users)"));
	real=new QCheckBox(i18n("&Real"), this);
	real->move(width()/3*2,y);	y+=real->height();
	QToolTip::add(real,i18n("Real users"));
	QLabel *lbl2=new QLabel(i18n("A&ddresses"), this);
	lbl2->move(0,y);
	addrglob=new QLineEdit(this);
	addrglob->setGeometry(lbl2->width(),y,320-lbl2->width(),addrglob->height());
	lbl2->setBuddy(addrglob);
	QToolTip::add(addrglob,i18n("Specify the addresses for this user class here;\nmay be globbed:\n* = any address\n*.localdomain.com = any address in localdomain.com\n127.0.0.* = IPs 127.0.0.1-127.0.0.255\n..."));
	QToolTip::add(lbl2,i18n("Specify the addresses for this user class here;\nmay be globbed:\n* = any address\n*.localdomain.com = any address in localdomain.com\n127.0.0.* = IPs 127.0.0.1-127.0.0.255\n..."));
	y+=addrglob->height()+5;
	ok=new QPushButton(i18n("&OK"),this);
	ok->setDefault(true);
	ok->setAutoDefault(true);
	ok->setGeometry(0,y,this->width()/2-5,ok->height());
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"),this);
	cancel->setGeometry(this->width()/2+5,y,this->width()/2-5,cancel->height());
	connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
	show();
}
NewClass::~NewClass()
{
	delete name;
	delete anon;
	delete guest;
	delete real;
	delete addrglob;
}
void NewClass::okButtonPressed()
{
	ftpclass *newclass;
	QString cn=name->text();
	QString ad=addrglob->text();
	if(cn.isEmpty()) {
		KMessageBox::sorry(this, i18n("Class name may not be empty."));
		return;
	}
	if(cn.find(' ') != -1 || cn.find('\t') != -1) {
		KMessageBox::sorry(this, i18n("Class name may not contain whitespaces"));
		return;
	}
	if(!anon->isChecked() && !guest->isChecked() && !real->isChecked()) {
		KMessageBox::sorry(this, i18n("You must check at least one of Anonymous, Guest or Real!"));
		return;
	}
	if(ad.isEmpty()) {
		if(KMessageBox::warningYesNo(this,
			i18n("Addresses can not be empty. Assume '*'?"))==KMessageBox::Yes)
				addrglob->setText("*");
	}

	ad=addrglob->text();
	if(ad.isEmpty())
		return;

	newclass=new ftpclass;
	newclass->setName(cn);
	newclass->setAnon(anon->isChecked());
	newclass->setGuest(guest->isChecked());
	newclass->setReal(real->isChecked());
	newclass->setAddrs(ad);
	emit classAdded(newclass);
	delete this;
}
void NewClass::cancelButtonPressed()
{
	delete this;
}
