    /*

    Miscellany functions for kdm's greeter
    $Id: miscfunc.h,v 1.4.2.1 2001/03/15 17:35:06 ossi Exp $

    Copyright (C) 2001 Oswald Buddenhagen <ossi@kde.org>


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _MISCFUNC_H
#define _MISCFUNC_H

#include "dm.h"
#include "greet.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _AIX
# define __FULL_PROTO 1
# include <sys/id.h>
int setegid (gid_t egid);
#endif

#ifndef HAVE_SETEUID
# undef seteuid		/* from config.h */
# define seteuid(euid) setreuid(-1, euid)
# define setegid(egid) setregid(-1, egid)
#endif /* HAVE_SETEUID */

#define F_LEN 50	/* user, password, session string len */

int s_copy (char *, const char *, int, int);

#if defined( HAVE_INITGROUPS) && defined( HAVE_GETGROUPS) && defined( HAVE_SETGROUPS)
# define USE_RDWR_WM
# define WMRC ".wmrc"
int rdwr_wm (char *wm, int wml, const char *usr, int rd);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _MISCFUNC_H */
