/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __CLOCK_H
#define __CLOCK_H

#include <qlcdnumber.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qguardedptr.h>
#include <qdatetime.h>
#include <qvbox.h>

#include <kpanelapplet.h>
#include <kdatepik.h>

class QTimer;
class QBoxLayout;
class KConfig;


class DatePickerWidget : public KDatePicker
{
public:
	DatePickerWidget(QWidget*);
	~DatePickerWidget();
};


class DatePicker : public QVBox
{
public:
	DatePicker(QWidget*);
	~DatePicker();
private:
	DatePickerWidget *picker;
};


class ClockConfDialog;

class ClockSettings : public QObject
{
  Q_OBJECT

public:
	enum ClockType { Analog = 0, Digital, Fuzzy };

	ClockSettings(QWidget* app, KConfig* conf);
	~ClockSettings();
	void writeSettings();

	void openPreferences();

	void setType(ClockType type);

	ClockType type()     { return _type; }
	bool lcdStyle()      { return _type == Digital?_lcdStyleDig:_lcdStyleAna; }
        bool showSeconds()   { return _type == Digital?_showSecsDig:_showSecsAna; }
        bool showDate();
	QColor foreColor();
	QColor shadowColor() { return _type == Digital?_shadowColorDig:_shadowColorAna; }
	QColor backColor();
	bool blink()         { return _blink; }
        QFont font()         { return _fontFuz; }
        int fuzzyness()      { return _fuzzynessFuz; }

signals:
	void newSettings();

protected slots:
	void dlgOkClicked();
	void dlgApplyClicked();
	void dlgCancelClicked();
	void dlgDeleted();
        void dlgbChooseFontClicked();

protected:
        QWidget *applet;
	KConfig *config;
	ClockType _type;
	QGuardedPtr<ClockConfDialog> confDlg;

	bool _lcdStyleAna, _lcdStyleDig,
	     _showSecsAna, _showSecsDig,
	     _showDateAna, _showDateDig, _showDateFuz,
	     _blink;
	QColor _foreColorAna, _foreColorDig, _foreColorFuz,
	       _backColorAna, _backColorDig, _backColorFuz,
	       _shadowColorAna, _shadowColorDig;
 	bool colAnalogModified, colDigitalModified, colFuzzyModified;
        int _fuzzynessFuz;
        QFont _fontFuz;

};


class DigitalClock : public QLCDNumber
{
  Q_OBJECT

public:
	DigitalClock(ClockSettings* set, QWidget *parent=0, const char *name=0);
	~DigitalClock();
        QSize sizeHint() const;
        int heightForWidth(int w) const;
        int widthForHeight(int h) const;

public slots:
	void slotUpdate();
	void relayout();

protected:
	void paintEvent( QPaintEvent*);
	void drawContents( QPainter * p);
	void resizeEvent ( QResizeEvent *ev);
        void styleChange( QStyle& );

	QPixmap *buffer;
	QString timeStr;
	bool ampm;
	ClockSettings *settings;

};


class AnalogClock : public QFrame
{
  Q_OBJECT

public:
	AnalogClock(ClockSettings* set, QWidget *parent=0, const char *name=0);
	~AnalogClock();

protected slots:
	void slotUpdate();

protected:
	virtual void paintEvent( QPaintEvent * );
        void styleChange( QStyle& );

	QTime time;
	ClockSettings *settings;

};


class ClockApplet;

class FuzzyClock : public QFrame
{
  Q_OBJECT

public:
	FuzzyClock(ClockSettings* set, QWidget *parent=0, const char *name=0);
	~FuzzyClock();
        QSize sizeHint() const;


protected slots:
	void slotUpdate();

protected:
	virtual void drawContents(QPainter *p);

	QTime time;
        QString timeStr;
	ClockSettings *settings;
        ClockApplet *_parent;

};


class ClockApplet : public KPanelApplet
{
  Q_OBJECT
  friend class ClockSettings;

public:
	ClockApplet(const QString& configFile, Type t = Normal, int actions = 0,
	            QWidget *parent = 0, const char *name = 0);
	~ClockApplet();

	int widthForHeight(int h) const;
	int heightForWidth(int w) const;
	void preferences();
        void intUpdateLayout()          { emit(updateLayout()); }
        Orientation getOrientation()    { return orientation(); }

public slots:
	void slotApplySettings();

signals:
	void layoutChanged();

protected slots:
	void slotUpdate();
	void slotCalendarDeleted();
	void slotEnableCalendar();
	void copyMenuActivated( int id );

protected:
	void openCalendar();
	void openContextMenu();
	void relayout();

	void mousePressEvent(QMouseEvent *ev);
	void resizeEvent ( QResizeEvent *ev);
	bool eventFilter( QObject *, QEvent * );

	ClockSettings *settings;
	DatePicker *cal;
	bool disableCalendar;
	QWidget *clock;
	QLabel *date;
	QDate lastDate;
	QTimer *timer;

};


#endif
