/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panel_h__
#define __panel_h__

#include <qwidget.h>
#include <qbutton.h>
#include <dcopobject.h>

#include "global.h"

class QBoxLayout;
class QPopupMenu;
class QVBox;
class QTimer;
class ContainerArea;
class ContainerAreaBox;
class PanelOpMenu;
class HideButton;
class ScrollButton;

class Panel : public QWidget, virtual public DCOPObject
{
    Q_OBJECT
    K_DCOP

public:
    Panel();
    ~Panel();

k_dcop:
    int panelSize() { return static_cast<int>(size()); }
    int panelOrientation() { return static_cast<int>(orientation()); }
    int panelPosition() { return static_cast<int>(position()); }

    void setPanelSize(int size) { setSize(static_cast<Size>(size)); }
    void setPanelPosition(int position) { setPosition(static_cast<Position>(position)); }

    // It makes sence to have these in Panel and not in ContainerArea, think of child panels.
    void addKMenuButton();
    void addDesktopButton();
    void addWindowListButton();
    void addURLButton(const QString &url);
    void addBrowserButton(const QString &startDir);
    void addServiceMenuButton(const QString &name, const QString& relPath);
    void addExeButton(const QString &filePath, const QString &icon, const QString &cmdLine, bool inTerm);

    void addApplet( const QString &desktopFile  );
    void addExtension( const QString &desktopFile );

    void configure();
    void restart();

public:
    Size size() const { return _size; }
    Orientation orientation() const {  return isHorizontal()?Horizontal:Vertical; }
    Position position() const { return _pos; }

    void setSize(Size s);
    void setPosition(Position p);

    ContainerArea *containerArea() { return(_containerArea); }

    bool eventFilter( QObject *, QEvent * );
    void writeConfig();
    QRect initialGeometry();

signals:
    void configurationChanged();

protected:
    bool isHorizontal() const { return _pos == Top || _pos == Bottom; }
    bool isVertical() const { return _pos == Left || _pos == Right; }
    void blockUserInput( bool block );
    void resetLayout();
    void closeEvent( QCloseEvent * );
    void updateWindowManager();
    void moveMe();
    void resetAutoHideTimer();
    void autoHide(bool hide);

    QPoint getPopupPosition(QPopupMenu *menu);

protected slots:
    void hideLeft();
    void hideRight();
    void autoHideTimeout();
    void slotRestart();
    void strutChanged();
    void showScrollButtons(bool);

private:

    void animatedHide(bool left);

    Size _size;
    Position _pos;
    bool _showHBs;
    int _HBwidth;
    int _panelsize;
    bool _autoHide;
    bool _autoHidden;
    bool _userHidden;
    bool _hideAnim, _autoHideAnim;
    int _autoHideDelay;
    int _hideAnimSpeed, _autoHideAnimSpeed;

    bool _block_user_input;
    bool _in_autohide;
    QPoint _last_lmb_press;

    ContainerAreaBox *_containerAreaBox;
    ContainerArea    *_containerArea;
    QBoxLayout       *_layout;
    QTimer           *_autohideTimer;
    HideButton       *_ltHB;
    HideButton       *_rbHB;
    ScrollButton     *_luSB;
    ScrollButton     *_rdSB;
    PanelOpMenu      *_opMnu;

    bool _faked_activation;
};

class ScrollButton : public QButton
{
    Q_OBJECT

public:
    ScrollButton(QWidget *parent=0, const char *name=0);

    QSize sizeHint() const { return QWidget::sizeHint(); }
    QSizePolicy sizePolicy() const { return QWidget::sizePolicy(); }

public slots:
    void setPosition(Position pos);

protected:
    void paintEvent(QPaintEvent *);

private:
    Position _pos;
};

#endif // __panel_h__
