// -*- c++ -*-

/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __KASBAR_H
#define __KASBAR_H

#include <qlist.h>
#include <qlayout.h>
#include <qwidget.h>

class KWinModule;
class KConfig;
class QBoxLayout;
class KasItem;
class QBitmap;
class KPixmap;
class KRootPixmap;

/**
 * The main view for KasBar. This is the class that does all the
 * work and handles the drawing, config, status etc.
 *
 * @version $Id: kasbar.h,v 1.4 2000/12/17 12:00:51 elter Exp $
 */
class KasBar : public QWidget
{
    Q_OBJECT
public:
    KasBar(KConfig* config, Orientation o, QWidget* parent = 0, const char* name = 0);

    void setOrientation(Orientation o){ orient = o; updateLayout();}
    Orientation orientation(){ return orient; }

    unsigned int buttons(){ return items.count(); }

    QSize sizeHint( Orientation o, QSize max );
    void updateLayout();

    void rescanWindows();

    /**
     * Asks KWin to display the window menu for id using DCOP.
     */
    void showWindowMenuAt( WId id, int x, int y );

public slots:
    void desktopChanged();

signals:
    /**
     * Emitted when kasbar wants to resize. This happens when a new window is added.
     */
    void layoutChanged();

protected slots:
    /**
     * Connected to the KWinModule and called when a new is window is mapped.
     */
    void windowAdded(WId);

    /**
     * Connected to the KWinModule and called when a window is unmapped.
     */
    void windowRemoved(WId);

    /**
     * Connected to the KWinModule and called when one or more of the properties
     * of a window have changed. This could be the icon, the title or any other
     * property defined by the NET WM protocol or KDE's extensions.
     *
     * @param window The id of the modified window.
     * @param changeMask A set of flags indicating which properties have changed.
     */
    void windowChanged(WId,unsigned int);

    /**
     * Connected to the KWinModule and called when window the active window
     * is changed. This is called no matter what caused the change, and may
     * be called to indicate that no window is active.
     */
    void activeWindowChanged(WId);

protected:
    /**
     * Displays the popup menus, hides/shows windows.
     */
    void mousePressEvent(QMouseEvent *ev);

    void paintEvent(QPaintEvent *ev);
    void resizeEvent(QResizeEvent *ev);

    /**
     * Draws a single item at the specified position.
     */
    void drawItem(QPainter *p, KasItem *i, int x, int y);

    /**
     * Redraws the specified item.
     */
    void repaintItem(KasItem *i);

    /**
     * Returns the item at p or 0.
     */
    KasItem* itemAt(const QPoint &p);

    /**
     * Find the item for the specified window. Returns 0 if there is no
     * such item.
     */
    KasItem* findItem( WId w );

private:
    QList<KasItem> items;
    Orientation orient;
    KWinModule *kwin_module;
    KRootPixmap *rootPix;

    //
    // Configuration Options
    //
    unsigned int maxBoxes;
    bool currentDesktopOnly;

    bool transparent;
    bool fillBg;
    bool enableTint;
    QColor tintColour;
    double tintAmount;

    //
    // State Icons and fills
    //
    KPixmap *actBg;
    KPixmap *inactBg;
    QBitmap *minPix;
    QBitmap *maxPix;
    QBitmap *shadePix;
};



#endif
