#include <qwhatsthis.h>
#include <kglobal.h>
#include <klocale.h>
#include "kasbar.h"
#include "kasbarextension.h"
#include "kasbarextension.moc"

extern "C"
{
    KPanelExtension *init( QWidget *parent, const QString& configFile )
    {
        KGlobal::locale()->insertCatalogue("kasbarextension");
        return new KasBarExtension( configFile,
                                    KPanelExtension::Stretch,
                                    KPanelExtension::About | KPanelExtension::Help | KPanelExtension::Preferences,
                                    parent, "kasbarextension");
    }
}

KasBarExtension::KasBarExtension( const QString& configFile,
                                  Type type,
                                  int actions,
                                  QWidget *parent, const char *name )
    : KPanelExtension( configFile, type, actions, parent, name )
{
    kasbar = new KasBar( config(), orientation(), this, name );
    connect( kasbar, SIGNAL( layoutChanged() ), this, SIGNAL( updateLayout() ) );
}

KasBarExtension::~KasBarExtension()
{
}

void KasBarExtension::resizeEvent(QResizeEvent*)
{
    kasbar->setOrientation( orientation() );
    kasbar->setGeometry(0, 0, width(), height());
}

QSize KasBarExtension::sizeHint(Position p, QSize maxSize ) const
{
    Orientation o;
    if (p == Top || p == Bottom)
        o = Horizontal;
    else
        o = Vertical;

    return kasbar->sizeHint(o, maxSize);
}

void KasBarExtension::positionChange( Position /* position */)
{
    kasbar->setOrientation( orientation() );
    kasbar->updateLayout();
}

void KasBarExtension::about()
{
    QApplication::beep();
}

void KasBarExtension::help()
{
    QWhatsThis::enterWhatsThisMode();
}

void KasBarExtension::preferences()
{
    QApplication::beep();
    QWhatsThis::enterWhatsThisMode();
}
