/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000 Jens Hoefkens
  hoefkens@pilot.msu.edu

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
*/

#ifndef __KBG_H 
#define __KBG_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kmainwindow.h>
#include <ktoolbar.h>
#include <qtextview.h>
#include <kaction.h>
#include <klineedit.h>
#include <qtabdialog.h>
#include <qsplitter.h>
#include <kbgtextview.h>

#include "kbgengine.h"
#include "kbgboard.h"


class KBg : public KMainWindow
{
	Q_OBJECT
		
public:
	
	/**
	 * Each engine has its own identifier -- TODO: remove
	 */
	enum Engines {None, Offline, FIBS, GNUbg};
	
	/**
	 * Constructor creates the full main window
	 */
	KBg(QWidget *parent = 0, const char *name = 0);

	/**
	 * Destructor
	 */
	virtual ~KBg();
  
	/**
	 * Read various settings from the configuration files or
	 * set some reasonable defaults
	 */  
	void readConfig();
	
public slots:

         /**
	 * Set the caption to KFIBS_NAME + string + pipcount (if requested by 
	 * the user)
	 */
	void updateCaption(const QString &s);

	/**
	 * Slot to be called by the engine - it enables/disables buttons
	 * in the button bar
	 */
	void allowCommand(int cmd, bool f);

signals:

	/**
	 * Tell all listeners to write their settings to disk
	 */
	void saveSettings();

	/**
	 * Tell all listeners to restore their settings or use reasonable
	 * defaults
	 */
	void readSettings();

protected:

	/**
	 * Sets the backgammon engine to type
	 */
	void setupEngine(int type);

	/**
	 * Be able to stop the shutdown process - or close open connections
	 * if necessary.
	 */
	virtual bool queryExit();

	/**
	 * Initialize the actions
	 */
	void setupActions();

protected slots:

        /**
	 * Show the button bar - or not - depending on the corresponding action
	 */
        void toggleMenubar();
	void toggleToolbar(const char *s);
	void toggleMainToolbar();
	void toggleCmdline();
	void toggleStatusbar();
	void configureKeys();
	void configureToolbars();

	/**
	 * Starts the print dialog and asks the board to print itself
	 */
	void print();

	/**
	 * Takes text from the commandline and hands it over to the 
	 * current engine
	 */
	void handleCmd(const QString &);

	/**
	 * Invokes the main help in a kfm window
	 */
	void help();

	/**
	 * Saves the user settings to disk
	 */
	void saveConfig();

	/**
	 * Slots for the respective actions - called by the button bar
	 * and some global key shortcuts
	 */
	void undo();
	void redo();
	void roll();
	void cube();
	void load();
	void done();

	/**
	 * Opens and displays the respective home pages
	 */
	void showWWWFIBS();
	void showWWWHome();

	/**
	 * Create and initialize the respective engines
	 */
	void setupEngineOffline();
	void setupEngineFIBS();
	void setupEngineGNUbg();

	/**
	 * Show the big setup dialog
	 */
	void setupDlg();

	/**
	 * Save the settings
	 */
	void setupOk();

	/**
	 * Undo the settings
	 */
	void setupCancel();

private:

	/**
	 * Notebook for the setup
	 */
	QTabDialog *nb;

	/**
	 * Main UI elements
	 */
	QSplitter     *panner;
	KBgBoardSetup *board;
	//KEdit         *status;
	KBgTextView   *status;
	KLineEdit     *commandLine;
	QLabel        *commandLabel;
	
	/**
	 * Backgammon engine
	 */	 
	KBgEngine *engine;
	int currentEngine;	
};

#endif // __KBG_H 
