/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef MYMULTILINEEDIT_H
#define MYMULTILINEEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qmultilineedit.h>

class EditCommand;

class MyMultiLineEdit : public QMultiLineEdit
{
   Q_OBJECT
public:
   MyMultiLineEdit(QWidget* parent,const char* name=0);
   virtual ~MyMultiLineEdit();

   /**
      applies cmd to the displayed text, but does not emit
      signalUndoCommand
   */
   void processCommand(EditCommand* cmd, bool undo=false);

   bool hasMarkedText();
   QString markedText();
   /** 
	* @returns the position in text, where the marked text begins
	* -1, if there is no marked text
	*/
   int beginOfMarkedText() const;

   virtual void insertAt ( const QString & s, int line, int col, bool mark = false );
   virtual void removeLine ( int line );

   int pos2Offset(int row, int col) const;
   void offset2Pos(int offset, int &row, int &col) const;

public slots:
   void clear();
   void paste();
   virtual void setReadOnly(bool on); 

protected:
   /*
   * reimplemented because QMultilineEdit doesn't send textChanged, when a drop is done
   */
   virtual void dropEvent(QDropEvent*);

   /*
   * only temporary implemented, because clear() is not
   * handled by edit command mechanism
   */
   virtual void mousePressEvent(QMouseEvent*);

   /* the parent handles this */
   virtual void wheelEvent(QWheelEvent*);

   virtual void del();
   virtual void insert ( const QString &, bool mark );
   virtual void killLine ();

   bool emitUndo;

signals:
   void signalUndoCmd(EditCommand*);
};


class MsgMultiLineEdit : public MyMultiLineEdit
{
   Q_OBJECT
public:
   MsgMultiLineEdit(QWidget* parent,const char* name=0);
   virtual ~MsgMultiLineEdit();

   /** is displaying surrounding quotes enabled? */
   bool quotes() const { return _quotes;}
   /** enable or disable displaying of surrounding quotes */
   void setQuotes(bool on);

   /** is highlighting background enabled? */
   bool highlightBg() const { return _highlightBg; }
   /** enable or disable highlighting background*/
   void setHighlightBg(bool on);
   QColor bgColor() const { return _bgColor; }
   void setBgColor(const QColor& color);

   bool spacePoints() const { return _spacePoints; }
   void setSpacePoints(bool on);

   bool highlightSyntax() const { return _hlSyntax; }
   void setHighlightSyntax(bool on);
   void setHighlightColors(const QColor& quoteColor, const QColor& unquoteColor
             , const QColor& cformatColor, const QColor& accelColor);

   void setFont(const QFont& font);

protected:
   virtual void paintCell( QPainter *painter, int row, int );
   /**
   *   needed to reimplement, to be able to display surrounding quotes
   */
   virtual void setCellWidth(int);

   /**
   * reimplemented to enable drawing cursor at drag events
   */
   virtual void dragMoveEvent(QDragMoveEvent*);

   /**
    * reimplemented to adjust mouse position when surrounding quotes
    * are displayed
    */
   virtual void mousePressEvent(QMouseEvent*);
   /**
    * reimplemented to adjust mouse position when surrounding quotes
    * are displayed
    */
   virtual void mouseReleaseEvent(QMouseEvent*);
   /**
    * reimplemented to adjust mouse position when surrounding quotes
    * are displayed
    */
   virtual void mouseMoveEvent(QMouseEvent*);
   /**
    * reimplemented to adjust mouse position when surrounding quotes
    * are displayed
    */
   virtual void mouseDoubleClickEvent(QMouseEvent*);


private:
   /**
   * Computes the pixel position in line line which corresponds to
   * character position xIndex
   */
   int mapToView( int xIndex, int row );
   void updateCellWidth();

private:
   bool _quotes;
   bool _highlightBg;
   bool _spacePoints;
   QColor _bgColor;

   bool _hlSyntax;
   QColor _quoteColor;
   QColor _unquoteColor;
   QColor _cformatColor;
   QColor _accelColor;

   bool dnd_forcecursor;
};

#endif // MYMULTILINEEDIT_H
