/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "settings.h"
#include "resources.h"

#include <qstring.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstddirs.h>


const QColor Defaults::Editor::bgColor=QColor(255,255,192);
const QColor Defaults::Editor::quotedColor=QColor(Qt::darkGreen);
const QColor Defaults::Editor::errorColor=QColor(Qt::red);
const QColor Defaults::Editor::cformatColor=QColor(Qt::blue);
const QColor Defaults::Editor::accelColor=QColor(Qt::darkMagenta);
const QColor Defaults::Editor::ledColor=QColor(Qt::red);
QString Defaults::Editor::_ignoreURL=QString::null;

QFont Defaults::Editor::msgFont()
{
   return KGlobalSettings::generalFont();
}

QString Defaults::Editor::ignoreURL()
{
	if(_ignoreURL.isEmpty())
	{
		KStandardDirs * dirs = KGlobal::dirs();
		if(dirs)
		{
			_ignoreURL = dirs->saveLocation("appdata");
			if(_ignoreURL.right(1)!="/")
				_ignoreURL+="/";
			_ignoreURL += "spellignores";
		}
	}

	return _ignoreURL;
}

const QString Defaults::Search::defaultModule="pocompendium";

QString Defaults::CatalogManager::poBaseDir()
{
   if(_poBaseDir.isNull())
   {
      _poBaseDir="";
   }

   return _poBaseDir;
}

QString Defaults::CatalogManager::potBaseDir()
{
   if(_potBaseDir.isNull())
   {
      _potBaseDir="";
   }

   return _potBaseDir;
}


QStringList Defaults::CatalogManager::dirCommands()
{
   QStringList cmds;
   cmds.append("make");
   cmds.append("make install");
   cmds.append("cvs update");

   return cmds;
}

QStringList Defaults::CatalogManager::dirCommandNames()
{
   QStringList cmds;
   cmds.append(i18n("Make"));
   cmds.append(i18n("Make install"));
   cmds.append(i18n("Update CVS"));

   return cmds;
}

QStringList Defaults::CatalogManager::fileCommands()
{
   QStringList cmds;

   cmds.append("@PACKAGE@");
   cmds.append("msgfmt -o @PACKAGE@.gmo @PACKAGE@.po");

   return cmds;
}

QStringList Defaults::CatalogManager::fileCommandNames()
{
   QStringList cmds;

   cmds.append(i18n("Run Application"));
   cmds.append(i18n("Compile"));

   return cmds;
}

QString Defaults::CatalogManager::_poBaseDir=QString::null;
QString Defaults::CatalogManager::_potBaseDir=QString::null;

