#include <artsflow.h>
#include <stdsynthmodule.h>
#include <flowsystem.h>
#include "StereoVolumeControl_Noatun.h"

using namespace Arts;

namespace Arts {

class StereoVolumeControl_Noatun_impl : virtual public StereoVolumeControl_Noatun_skel,
                                        virtual public StdSynthModule
{
	long mPercent;
public:
	StereoVolumeControl_Noatun_impl() : mPercent(100)
	{ }

	/*attribute float scaleFactor;*/
	void percent(long p) { mPercent=p; }
	long percent() { return mPercent; }

	void calculateBlock(unsigned long samples)
	{
		register float p=((float)mPercent)/100.0;

		float *left=inleft;
		float *right=inright;
		float *end=left+samples;

		float *oleft=outleft;
		float *oright=outright;

		while (left<end)
		{
			*oleft=*left * p;
			*oright=*right * p;

			++left;
			++right;
			++oleft;
			++oright;
		}
	}
};

REGISTER_IMPLEMENTATION(StereoVolumeControl_Noatun_impl);
};

