#include "noatunstdaction.h"
#include "noatunapp.h"
#include "player.h"

#include <klocale.h>
#include <kiconloader.h>

/**
 * A namespace to have all of noatun's standard actions
 * This is treated like KStdAction
 **/
namespace NoatunStdAction	
{
/////////////////////////////////////////////////////
PlayAction::PlayAction(QObject *parent, const char *name)
	: KAction(i18n("Play"), 0, napp->player(), SLOT(playpause()), parent, name)
{
	connect(napp->player(), SIGNAL(playing()), SLOT(playing()));
	connect(napp->player(), SIGNAL(paused()), SLOT(notplaying()));
	connect(napp->player(), SIGNAL(stopped()), SLOT(notplaying()));
	if (napp->player()->isPlaying())
		playing();
	else if (napp->player()->isPaused() || napp->player()->isStopped())
		notplaying();
}

void PlayAction::playing()
{
	setIconSet(QIconSet(SmallIcon("noatunpause")));
	setText(i18n("Pause"));
}

void PlayAction::notplaying()
{
	setIconSet(QIconSet(SmallIcon("noatunplay")));
	setText(i18n("Play"));
}
/////////////////////////////////////////////////////

PlaylistAction::PlaylistAction(QObject *parent, const char *name)
	: KToggleAction(i18n("Show Playlist"), 0, napp->player(), SLOT(toggleListView()), parent, name)
{
	connect(napp->player(), SIGNAL(playlistShown()),  SLOT(shown()));
	connect(napp->player(), SIGNAL(playlistHidden()), SLOT(hidden()));
	setChecked(napp->playlist()->listVisible());
}

void PlaylistAction::shown()
{
	setChecked(true);
}

void PlaylistAction::hidden()
{
	setChecked(false);
}

////////////////////////////////////////////////////

KAction *playpause(QObject *parent, const char *name)
{
	return new PlayAction(parent, name);
}

KAction *effects(QObject *parent, const char *name)
{
	return new KAction(i18n("&Effects..."), "effect", 0, napp, SLOT(effectView()), parent, name);
}

KAction *equalizer(QObject *parent, const char *name)
{
	return new KAction(i18n("&Equalizer..."), 0, napp, SLOT(equalizerView()), parent, name);
}

KAction *back(QObject *parent, const char *name)
{
	return new KAction(i18n("Back"), "noatunback", 0, napp->player(), SLOT(back()), parent, name);
}

KAction *stop(QObject *parent, const char *name)
{
	return new KAction(i18n("Stop"), "noatunstop", 0, napp->player(), SLOT(stop()), parent, name);
}
	
KAction *forward(QObject *parent, const char *name)
{
	return new KAction(i18n("Forward"), "noatunforward", 0, napp->player(), SLOT(fastForward()), parent, name);
}

KToggleAction *playlist(QObject *parent, const char *name)
{
	return new PlaylistAction(parent, name);
}

}
