// -*- c++ -*-

#ifndef KVNC_H
#define KVNC_H

#include <kmainwindow.h>

class KToggleAction;
class KRFBCanvas;
class QPushButton;

/**
 * Top level window for Keystone.
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id: kvnc.h,v 1.5 2000/12/04 23:10:08 rich Exp $
 */
class KVNC : public KMainWindow
{
  Q_OBJECT
public: 
  KVNC( const char *name = 0 );
  ~KVNC(); 

public slots:
  void toggleFullScreen();
  void toggleShowStatus();
  void toggleShowToolbar();
  void toggleShowMenu();
  void openURL( const KURL &url );
  void showOptions();

protected:
  void setupActions();
  void setupMenuBar();
  void setupStatusBar();

protected slots:
  void showAboutApplication();

private:
  bool fullscreen;
  KRFBCanvas *canvas;
  KPopupMenu *cornerMenu;
  QPushButton *cornerButton;
  KAction *fullScreenAction;
  KToggleAction *menubarAction;
  KToggleAction *toolbarAction;
  KToggleAction *statusbarAction;
};

#endif // KVNC_H
