#ifndef KCMNEWSTICKER_H
#define KCMNEWSTICKER_H

#include "kcmnewstickerwidget.h"

#include <kcmodule.h>
#include <kconfig.h>

#include <qevent.h>
#include <qfont.h>

class KCMNewsTickerWidget;

class KCMNewsTicker: public KCModule
{
	Q_OBJECT

	public:
		KCMNewsTicker(QWidget* = 0, const char* = 0);

		void load();
		void save();
		void defaults();

		int buttons();
		QString quickHelp() const;

		QSize minimumSizeHint() const { return _child->minimumSizeHint(); }

	protected:
		void addNewsSource(const QString &, const QString &, uint = 10, bool = false);
		void addNewsSource(QListViewItem *);
		void removeNewsSource(QListViewItem *);
		void resizeEvent(QResizeEvent *);
		bool eventFilter(QObject *, QEvent *);

	protected slots:
		void slotConfigChanged();
		void slotContextMenu(KListView *, QListViewItem *, const QPoint &);
		void slotSelectionChanged(QListViewItem *);
		void slotChooseFont();
		void slotAddNewsSource();
		void slotRemoveNewsSource();
		void slotNameChanged(const QString &);
		void slotSourceFileChanged(const QString &);
		void slotMaxArticlesChanged(int);
		void slotMoveItemUp();
		void slotMoveItemDown();
		void slotBrowse();

	private:
		KConfig *_config;
		KCMNewsTickerWidget *_child;
		QFont _font;
};

#endif // KCMNEWSTICKER_H
