/*
 * knewsticker.h
 *
 * Copyright (c) 2000 Frerich Raabe <raabe@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef KNEWSTICKER_H
#define KNEWSTICKER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qintdict.h>
#include <qtoolbutton.h>
#include <kpanelapplet.h>
#include <newsscroller.h>
#include <knewstickeriface.h>
#include <kpopupmenu.h>

class KInstance;
class NewsSource;
class ArrowButton;
class KPopupMenu;
class KNewsTickerMenu;
class KAboutData;

class KNewsTicker : public KPanelApplet, virtual public KNewsTickerIface
{
	Q_OBJECT

	public:
		KNewsTicker(const QString &, Type, int, QWidget * = 0, const char * = 0);
		virtual ~KNewsTicker();

		int widthForHeight(int) const;
		int heightForWidth(int) const;

		void preferences();
		void about();
		void help();

		virtual void action(Action);

		virtual void reparseConfig();

		ArrowType getArrowType();

		QIntDict<NewsSource> newsSource() const { return _newsSource; };

		bool offlineMode() const { return _offlineMode; };
		virtual void setOfflineMode(bool);

		bool customNames() const { return _customNames; };

		uint updateId() const { return _updateId; };
		void setUpdateId(uint updateId) { _updateId = updateId; };

		virtual void updateNews() { slotUpdateNews(); }

	public slots:
		void slotUpdateNews();
		void slotOpenContextMenu();

	protected:
		void readConfig();
		void mousePressEvent(QMouseEvent *);
		virtual void orientationChange(Orientation);

	protected slots:
		void slotArrowButtonPressed();
		void slotNewsUpdated(NewsSource *, uint, bool);
		void slotContextMenuAboutToHide();
		void slotInvalidInput(const QString &);

	private:
		KInstance *_instance;
		DCOPClient *_dcopClient;
		uint _interval, _scrollSpeed, _updateId, _notifyId;
		bool _customNames, _offlineMode, _endless, _underlineHighlighted,
			_scrollMostRecentOnly;
		QIntDict<NewsSource> _newsSource;
		QTimer *_newsTimer;
		QColor _foreground, _background, _highlighted;
		QFont _font;
		NewsScroller *_newsScroller;
		NewsScroller::Direction _direction;
		ArrowButton *_arrowButton;
		KNewsTickerMenu *_contextMenu;
		KConfig *_config;
		KAboutData *_aboutData;
};

class ArrowButton : public QToolButton
{
	Q_OBJECT

	public:
		ArrowButton(KNewsTicker *);

	protected:
		void drawButtonLabel(QPainter *);
		virtual QSize sizeHint() const;

	private:
		KNewsTicker *_parent;
};

class KNewsTickerMenu : public KPopupMenu
{
	Q_OBJECT

	public:
		KNewsTickerMenu(QWidget *, const char * = 0);
		int exec(const QPoint &, int = 0);

	private:
		KNewsTicker *_parent;
		uint _index;
};

#endif // KNEWSTICKER_H
