/*
 * newssource.h
 *
 * Copyright (c) 2000 Frerich Raabe <raabe@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef NEWSSOURCE_H
#define NEWSSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kconfig.h>
#include <kurl.h>

#include <qlist.h>
#include <qobject.h>

#include <kio/job.h>

class Article : public QObject
{
	Q_OBJECT
		
	public:
		Article(const QString & = QString::null, const KURL & = QString::null, bool = false);
		Article(const Article *);
		~Article() {};

		QString headline() const { return _headline; }
		void setHeadline(const QString &headline) { _headline = headline; }

		KURL address() const { return _address; }
		void setAddress(const KURL &address) { _address = address; }

		bool read() const { return _read; }
		void setRead(bool read) { _read = read; }

	public slots:
		void open();

	private:
		QString _headline;
		KURL _address;
		bool _read;
};

class KIO::Job;

class NewsSource : public QObject
{
	Q_OBJECT

	public:
		NewsSource(KConfig *, const QString &);
		NewsSource(const QString &, const QString & = QString::null);

		void load(KConfig *, const QString &);

		QString name() const { return _name; }

		uint articles() const { return _article.count(); }

		Article *article(uint No) { return _article.at(No); }
		Article *article(const QString &);

	signals:
		void newNewsAvailable(NewsSource *, uint, bool);
		void invalidInput(const QString &);

	public slots:
		void retrieveNews(bool, uint);

	protected slots:
		void downloadData(KIO::Job *, const QByteArray &);
		void downloadResult(KIO::Job *);

	private:
		QString _sourceFile, _name;
		QList<Article> _article;
		uint _maxArticles, _updateId;
		bool _customNames;
		QString _rdfData;
};

#endif // NEWSSOURCE_H
