/*
    knjobdata.h

    KNode, the KDE newsreader
    Copyright (c) 1999-2000 the KNode authors.
    See file AUTHORS for details

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, US
*/

#ifndef KNJOBDATA_H
#define KNJOBDATA_H

#include "knserverinfo.h"
#include <qlist.h>

class KNJobData;

class KNJobConsumer {

  public:
    KNJobConsumer();
    virtual ~KNJobConsumer();

    /* Send the job to KNNetAccess and append it to the
       joblist*/
    void emitJob(KNJobData *j);

    /* Remove the job from the joblist and process it by
       calling "processJob" */
    void jobDone(KNJobData *j);

    /* Returns TRUE if we are waiting for at least one job
       to be completed */
    bool jobsPending()  { return (j_obs.count()>0); }

  protected:
    /* The actual work is done here */
    virtual void processJob(KNJobData *j);
    QList<KNJobData> j_obs;

};


class KNJobItem {

  public:
    KNJobItem()           {}
    virtual ~KNJobItem()  {}

    virtual bool isLocked()         { return false; }
    virtual void setLocked(bool)    { }

};


class KNJobData {
  
  public:

    friend class KNJobConsumer;

    enum jobType {  JTLoadGroups=1,
                    JTFetchGroups,
                    JTCheckNewGroups,
                    JTfetchNewHeaders,
                    JTfetchArticle,
                    JTpostArticle,
                    JTmail };                   
    
    KNJobData(jobType t, KNJobConsumer *c, KNServerInfo *a, KNJobItem *i);
    ~KNJobData();
    
    jobType type() const                  { return t_ype; }
    
    bool net() const                      { return (t_ype!=JTLoadGroups); }
    KNServerInfo* account() const         { return a_ccount; }
    KNJobItem* data() const               { return d_ata; }
    
    const QString& errorString() const    { return e_rrorString; }
    bool success() const                  { return e_rrorString.isEmpty(); }
    bool canceled() const                 { return c_anceled; }
    
    void setErrorString(const QString& s) { e_rrorString=s; }
    void cancel() { c_anceled=true; }

    void notifyConsumer();

  protected:
    jobType t_ype;
    KNJobItem *d_ata;
    KNServerInfo *a_ccount;
    QString e_rrorString;
    bool c_anceled;
    KNJobConsumer *c_onsumer;
        
};


#endif
