/* GNU POP3 - a small, fast, and efficient POP3 daemon
   Copyright (C) 1999 Jakob 'sparky' Kaivo <jkaivo@nodomainname.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "gnu-pop3d.h"

/* Prints out the specified message */

int
pop3_retr (const char *arg)
{
  int mesg;
  int done = 0;
  char *buf, buf2[80];

  if ((strlen (arg) == 0) || (strchr (arg, ' ') != NULL))
    return ERR_BAD_ARGS;

  if (state != TRANSACTION)
    return ERR_WRONG_STATE;

  mesg = atoi (arg) - 1;

  if (pop3_mesg_exist (mesg) != OK)
    return ERR_NO_MESG;

  mbox = freopen (mailbox, "r", mbox);
  if (mbox == NULL)
    return ERR_FILE;
  fsetpos (mbox, &(messages[mesg].header));
  buf = malloc (sizeof (char) * 80);
  if (buf == NULL)
    pop3_abquit (ERR_NO_MEM);

  fprintf (ofile, "+OK\r\n");

  while (fgets (buf, 80, mbox) && !done)
    {
      while (strchr (buf, '\n') == NULL)
	{
	  buf = realloc (buf, sizeof (char) * (strlen (buf) + 81));
	  if (buf == NULL)
	    pop3_abquit (ERR_NO_MEM);
	  fgets (buf2, 80, mbox);
	  strncat (buf, buf2, 80);
	}
      if (!strncmp (buf, "From ", 5))
	done = 1;
      else
	{
	  buf[strlen (buf) - 1] = '\0';
	  if (buf[0] == '.')
	    fprintf (ofile, ".%s\r\n", buf);
	  else
	    fprintf (ofile, "%s\r\n", buf);
	}
      buf = realloc (buf, sizeof (char) * 80);
      if (buf == NULL)
	pop3_abquit (ERR_NO_MEM);
    }

  free (buf);
  fprintf (ofile, ".\r\n");
  return OK;
}
