/**
 *
 * $Header: /cvsroot/lesstif/lesstif/include/Motif-2.0/Xm/TransferP.h,v 1.8 2000/11/09 15:16:42 amai Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 * Copyright (C) 1997-2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/


#ifndef _XM_TRANSFERP_H
#define _XM_TRANSFERP_H

#include <Xm/Transfer.h>

#ifdef __cplusplus
extern "C" {
#endif

Atom *XmeStandardTargets(Widget widget,
                         int count, int *count_return);

void XmeStandardConvert(Widget widget,
                        XtPointer ignore,
			XmConvertCallbackStruct *call_data);

void XmeTransferAddDoneProc(XtPointer transfer_id,
                            XmSelectionFinishedProc done_proc);

Boolean XmeSecondarySink(Widget widget, Time time);

Boolean XmeSecondarySource(Widget widget,Time time);

void XmeSecondaryTransfer(Widget widget, Atom target,
                          XtEnum op, Time time);

Widget XmeDragSource(Widget widget, XtPointer location_data,
                     XEvent *event, ArgList args, Cardinal arg_count);

Boolean XmeNamedSink(Widget widget, Atom named_selection,
                     XtEnum op, XtPointer location_data,
                     Time time);

Boolean XmeNamedSource(Widget widget, Atom named_selection, 
                       Time time);

Boolean XmePrimarySink(Widget widget, XtEnum op, XtPointer location_data,
                       Time time);

Boolean XmePrimarySource(Widget widget, Time time);

Atom XmeGetEncodingAtom(Widget widget);

void XmeDropSink(Widget widget,
                 ArgList args,
                 Cardinal arg_count);


#ifdef __cplusplus
}
#endif

#endif /* _XM_TRANSFERP_H */
