/* REXX */
/* 
   ble.cmd
   $Id: ble.cmd,v 1.2 2001/05/22 20:13:19 amai Exp $

   Tool to build Xbae, Xlt, Xm test examples from within the
   LessTif source tree with OS/2 EMX.
*/

Parse Arg param

if param="" then
   do
   say "ble.cmd: No argument"
   exit 0
   end

/* configuration */
CC=gcc
DEBUG="-g"
CFLAGS="-Zmt -O0 -Wall -W -ansi"
LDFLAGS="-Zmt -Zcrtdll"

if right(param,2)=".c" then
   do
   base = Left(param, lastpos(".c", param)-1)
   end
else
   do
   base = param
   end

srcfile    = base".c"
objectfile = base".o"
exefile    = base".exe"

curdir = directory()
if Pos("Xlt", curdir)>0 then
   tree = "Xlt"
else if Pos("Xbae", curdir)>0 then
   tree = "Xbae"
else
   do
   tree = "Xm"
   end

say "tree:"tree

x11root = Value("X11ROOT",,"OS2ENVIRONMENT")
say "X11ROOT="x11root

if tree="Xbae" then
   do
   includes = "-I. -I../../include -I../../../../include/Motif-2.0  -I../../../../include/Motif-1.2"  
   libs     = "-L../../src -lXbae -L../../../lib/Xm-2.0 -lXm"
   end
else if tree="Xlt" then
   do
   includes = "-I. -I../../lib  -I../../../../include/Motif-2.0  -I../../../../include/Motif-1.2"  
   libs     = "-L../../lib -lXlt -L../../../lib/Mrm-2.0 -lMrm -L../../../lib/Xm-2.0 -lXm"  
   end
else
   do
   includes = "-I. -I../../../include/Motif-2.0  -I../../../include/Motif-1.2"
   libs     = "-L../../common -lLtTest -L../../../lib/Xm-2.0 -lXm"  
   end

/* Add non-LessTif libs */
libs = libs" -L"x11root"/Xfree86/lib -lXt -lX11"

/* execute the commands */
CC CFLAGS   DEBUG "-c -o "objectfile  includes  srcfile
CC LDFLAGS  DEBUG "   -o "exefile               objectfile  libs

exit 0
