#include "varicode.h"

/*
 * The IZ8BLY MFSK Varicode as defined in
 *   http://www.qsl.net/zl1bpu/MFSK/Varicode.html
 */
static char *varicode[] = {
	"11101011100",		/* 000 - <NUL>	*/
	"11101100000",		/* 001 - <SOH>	*/
	"11101101000",		/* 002 - <STX>	*/
	"11101101100",		/* 003 - <ETX>	*/
	"11101110000",		/* 004 - <EOT>	*/
	"11101110100",		/* 005 - <ENQ>	*/
	"11101111000",		/* 006 - <ACK>	*/
	"11101111100",		/* 007 - <BEL>	*/
	"10101000",		/* 008 - <BS>	*/
	"11110000000",		/* 009 - <TAB>	*/
	"11110100000",		/* 010 - <LF>	*/
	"11110101000",		/* 011 - <VT>	*/
	"11110101100",		/* 012 - <FF>	*/
	"10101100",		/* 013 - <CR>	*/
	"11110110000",		/* 014 - <SO>	*/
	"11110110100",		/* 015 - <SI>	*/
	"11110111000",		/* 016 - <DLE>	*/
	"11110111100",		/* 017 - <DC1>	*/
	"11111000000",		/* 018 - <DC2>	*/
	"11111010000",		/* 019 - <DC3>	*/
	"11111010100",		/* 020 - <DC4>	*/
	"11111011000",		/* 021 - <NAK>	*/
	"11111011100",		/* 022 - <SYN>	*/
	"11111100000",		/* 023 - <ETB>	*/
	"11111101000",		/* 024 - <CAN>	*/
	"11111101100",		/* 025 - <EM>	*/
	"11111110000",		/* 026 - <SUB>	*/
	"11111110100",		/* 027 - <ESC>	*/
	"11111111000",		/* 028 - <FS>	*/
	"11111111100",		/* 029 - <GS>	*/
	"100000000000",		/* 030 - <RS>	*/
	"101000000000",		/* 031 - <US>	*/
	"100",			/* 032 - <SPC>	*/
	"111000000",		/* 033 - !	*/
	"111111100",		/* 034 - '"'	*/
	"1011011000",		/* 035 - #	*/
	"1010101000",		/* 036 - $	*/
	"1010100000",		/* 037 - %	*/
	"1000000000",		/* 038 - &	*/
	"110111100",		/* 039 - '	*/
	"111110100",		/* 040 - (	*/
	"111110000",		/* 041 - )	*/
	"1010110100",		/* 042 - *	*/
	"111100000",		/* 043 - +	*/
	"10100000",		/* 044 - ,	*/
	"111011000",		/* 045 - -	*/
	"111010100",		/* 046 - .	*/
	"111101000",		/* 047 - /	*/
	"11100000",		/* 048 - 0	*/
	"11110000",		/* 049 - 1	*/
	"101000000",		/* 050 - 2	*/
	"101010100",		/* 051 - 3	*/
	"101110100",		/* 052 - 4	*/
	"101100000",		/* 053 - 5	*/
	"101101100",		/* 054 - 6	*/
	"110100000",		/* 055 - 7	*/
	"110000000",		/* 056 - 8	*/
	"110101100",		/* 057 - 9	*/
	"111101100",		/* 058 - :	*/
	"111111000",		/* 059 - ;	*/
	"1011000000",		/* 060 - <	*/
	"111011100",		/* 061 - =	*/
	"1010111100",		/* 062 - >	*/
	"111010000",		/* 063 - ?	*/
	"1010000000",		/* 064 - @	*/
	"10111100",		/* 065 - A	*/
	"100000000",		/* 066 - B	*/
	"11010100",		/* 067 - C	*/
	"11011100",		/* 068 - D	*/
	"10111000",		/* 069 - E	*/
	"11111000",		/* 070 - F	*/
	"101010000",		/* 071 - G	*/
	"101011000",		/* 072 - H	*/
	"11000000",		/* 073 - I	*/
	"110110100",		/* 074 - J	*/
	"101111100",		/* 075 - K	*/
	"11110100",		/* 076 - L	*/
	"11101000",		/* 077 - M	*/
	"11111100",		/* 078 - N	*/
	"11010000",		/* 079 - O	*/
	"11101100",		/* 080 - P	*/
	"110110000",		/* 081 - Q	*/
	"11011000",		/* 082 - R	*/
	"10110100",		/* 083 - S	*/
	"10110000",		/* 084 - T	*/
	"101011100",		/* 085 - U	*/
	"110101000",		/* 086 - V	*/
	"101101000",		/* 087 - W	*/
	"101110000",		/* 088 - X	*/
	"101111000",		/* 089 - Y	*/
	"110111000",		/* 090 - Z	*/
	"1011101000",		/* 091 - [	*/
	"1011010000",		/* 092 - \	*/
	"1011101100",		/* 093 - ]	*/
	"1011010100",		/* 094 - ^	*/
	"1010110000",		/* 095 - _	*/
	"1010101100",		/* 096 - `	*/
	"10100",		/* 097 - a	*/
	"1100000",		/* 098 - b	*/
	"111000",		/* 099 - c	*/
	"110100",		/* 100 - d	*/
	"1000",			/* 101 - e	*/
	"1010000",		/* 102 - f	*/
	"1011000",		/* 103 - g	*/
	"110000",		/* 104 - h	*/
	"11000",		/* 105 - i	*/
	"10000000",		/* 106 - j	*/
	"1110000",		/* 107 - k	*/
	"101100",		/* 108 - l	*/
	"1000000",		/* 109 - m	*/
	"11100",		/* 110 - n	*/
	"10000",		/* 111 - o	*/
	"1010100",		/* 112 - p	*/
	"1111000",		/* 113 - q	*/
	"100000",		/* 114 - r	*/
	"101000",		/* 115 - s	*/
	"1100",			/* 116 - t	*/
	"111100",		/* 117 - u	*/
	"1101100",		/* 118 - v	*/
	"1101000",		/* 119 - w	*/
	"1110100",		/* 120 - x	*/
	"1011100",		/* 121 - y	*/
	"1111100",		/* 122 - z	*/
	"1011011100",		/* 123 - {	*/
	"1010111000",		/* 124 - |	*/
	"1011100000",		/* 125 - }	*/
	"1011110000",		/* 126 - ~	*/
	"101010000000",		/* 127 - <DEL>	*/
	"101010100000",		/* 128 - 	*/
	"101010101000",		/* 129 - 	*/
	"101010101100",		/* 130 - 	*/
	"101010110000",		/* 131 - 	*/
	"101010110100",		/* 132 - 	*/
	"101010111000",		/* 133 - 	*/
	"101010111100",		/* 134 - 	*/
	"101011000000",		/* 135 - 	*/
	"101011010000",		/* 136 - 	*/
	"101011010100",		/* 137 - 	*/
	"101011011000",		/* 138 - 	*/
	"101011011100",		/* 139 - 	*/
	"101011100000",		/* 140 - 	*/
	"101011101000",		/* 141 - 	*/
	"101011101100",		/* 142 - 	*/
	"101011110000",		/* 143 - 	*/
	"101011110100",		/* 144 - 	*/
	"101011111000",		/* 145 - 	*/
	"101011111100",		/* 146 - 	*/
	"101100000000",		/* 147 - 	*/
	"101101000000",		/* 148 - 	*/
	"101101010000",		/* 149 - 	*/
	"101101010100",		/* 150 - 	*/
	"101101011000",		/* 151 - 	*/
	"101101011100",		/* 152 - 	*/
	"101101100000",		/* 153 - 	*/
	"101101101000",		/* 154 - 	*/
	"101101101100",		/* 155 - 	*/
	"101101110000",		/* 156 - 	*/
	"101101110100",		/* 157 - 	*/
	"101101111000",		/* 158 - 	*/
	"101101111100",		/* 159 - 	*/
	"1011110100",		/* 160 - 	*/
	"1011111000",		/* 161 - 	*/
	"1011111100",		/* 162 - 	*/
	"1100000000",		/* 163 - 	*/
	"1101000000",		/* 164 - 	*/
	"1101010000",		/* 165 - 	*/
	"1101010100",		/* 166 - 	*/
	"1101011000",		/* 167 - 	*/
	"1101011100",		/* 168 - 	*/
	"1101100000",		/* 169 - 	*/
	"1101101000",		/* 170 - 	*/
	"1101101100",		/* 171 - 	*/
	"1101110000",		/* 172 - 	*/
	"1101110100",		/* 173 - 	*/
	"1101111000",		/* 174 - 	*/
	"1101111100",		/* 175 - 	*/
	"1110000000",		/* 176 - 	*/
	"1110100000",		/* 177 - 	*/
	"1110101000",		/* 178 - 	*/
	"1110101100",		/* 179 - 	*/
	"1110110000",		/* 180 - 	*/
	"1110110100",		/* 181 - 	*/
	"1110111000",		/* 182 - 	*/
	"1110111100",		/* 183 - 	*/
	"1111000000",		/* 184 - 	*/
	"1111010000",		/* 185 - 	*/
	"1111010100",		/* 186 - 	*/
	"1111011000",		/* 187 - 	*/
	"1111011100",		/* 188 - 	*/
	"1111100000",		/* 189 - 	*/
	"1111101000",		/* 190 - 	*/
	"1111101100",		/* 191 - 	*/
	"1111110000",		/* 192 - 	*/
	"1111110100",		/* 193 - 	*/
	"1111111000",		/* 194 - 	*/
	"1111111100",		/* 195 - 	*/
	"10000000000",		/* 196 - 	*/
	"10100000000",		/* 197 - 	*/
	"10101000000",		/* 198 - 	*/
	"10101010000",		/* 199 - 	*/
	"10101010100",		/* 200 - 	*/
	"10101011000",		/* 201 - 	*/
	"10101011100",		/* 202 - 	*/
	"10101100000",		/* 203 - 	*/
	"10101101000",		/* 204 - 	*/
	"10101101100",		/* 205 - 	*/
	"10101110000",		/* 206 - 	*/
	"10101110100",		/* 207 - 	*/
	"10101111000",		/* 208 - 	*/
	"10101111100",		/* 209 - 	*/
	"10110000000",		/* 210 - 	*/
	"10110100000",		/* 211 - 	*/
	"10110101000",		/* 212 - 	*/
	"10110101100",		/* 213 - 	*/
	"10110110000",		/* 214 - 	*/
	"10110110100",		/* 215 - 	*/
	"10110111000",		/* 216 - 	*/
	"10110111100",		/* 217 - 	*/
	"10111000000",		/* 218 - 	*/
	"10111010000",		/* 219 - 	*/
	"10111010100",		/* 220 - 	*/
	"10111011000",		/* 221 - 	*/
	"10111011100",		/* 222 - 	*/
	"10111100000",		/* 223 - 	*/
	"10111101000",		/* 224 - 	*/
	"10111101100",		/* 225 - 	*/
	"10111110000",		/* 226 - 	*/
	"10111110100",		/* 227 - 	*/
	"10111111000",		/* 228 - 	*/
	"10111111100",		/* 229 - 	*/
	"11000000000",		/* 230 - 	*/
	"11010000000",		/* 231 - 	*/
	"11010100000",		/* 232 - 	*/
	"11010101000",		/* 233 - 	*/
	"11010101100",		/* 234 - 	*/
	"11010110000",		/* 235 - 	*/
	"11010110100",		/* 236 - 	*/
	"11010111000",		/* 237 - 	*/
	"11010111100",		/* 238 - 	*/
	"11011000000",		/* 239 - 	*/
	"11011010000",		/* 240 - 	*/
	"11011010100",		/* 241 - 	*/
	"11011011000",		/* 242 - 	*/
	"11011011100",		/* 243 - 	*/
	"11011100000",		/* 244 - 	*/
	"11011101000",		/* 245 - 	*/
	"11011101100",		/* 246 - 	*/
	"11011110000",		/* 247 - 	*/
	"11011110100",		/* 248 - 	*/
	"11011111000",		/* 249 - 	*/
	"11011111100",		/* 250 - 	*/
	"11100000000",		/* 251 - 	*/
	"11101000000",		/* 252 - n	*/
	"11101010000",		/* 253 - 	*/
	"11101010100",		/* 254 - 	*/
	"11101011000"		/* 255 - 	*/
};

/*
 * The same in a format more suitable for decoding.
 */
static unsigned int varidecode[] = {
	0x75C, 0x760, 0x768, 0x76C, 0x770, 0x774, 0x778, 0x77C, 
	0x0A8, 0x780, 0x7A0, 0x7A8, 0x7AC, 0x0AC, 0x7B0, 0x7B4, 
	0x7B8, 0x7BC, 0x7C0, 0x7D0, 0x7D4, 0x7D8, 0x7DC, 0x7E0, 
	0x7E8, 0x7EC, 0x7F0, 0x7F4, 0x7F8, 0x7FC, 0x800, 0xA00, 
	0x004, 0x1C0, 0x1FC, 0x2D8, 0x2A8, 0x2A0, 0x200, 0x1BC, 
	0x1F4, 0x1F0, 0x2B4, 0x1E0, 0x0A0, 0x1D8, 0x1D4, 0x1E8, 
	0x0E0, 0x0F0, 0x140, 0x154, 0x174, 0x160, 0x16C, 0x1A0, 
	0x180, 0x1AC, 0x1EC, 0x1F8, 0x2C0, 0x1DC, 0x2BC, 0x1D0, 
	0x280, 0x0BC, 0x100, 0x0D4, 0x0DC, 0x0B8, 0x0F8, 0x150, 
	0x158, 0x0C0, 0x1B4, 0x17C, 0x0F4, 0x0E8, 0x0FC, 0x0D0, 
	0x0EC, 0x1B0, 0x0D8, 0x0B4, 0x0B0, 0x15C, 0x1A8, 0x168, 
	0x170, 0x178, 0x1B8, 0x2E8, 0x2D0, 0x2EC, 0x2D4, 0x2B0, 
	0x2AC, 0x014, 0x060, 0x038, 0x034, 0x008, 0x050, 0x058, 
	0x030, 0x018, 0x080, 0x070, 0x02C, 0x040, 0x01C, 0x010, 
	0x054, 0x078, 0x020, 0x028, 0x00C, 0x03C, 0x06C, 0x068, 
	0x074, 0x05C, 0x07C, 0x2DC, 0x2B8, 0x2E0, 0x2F0, 0xA80, 
	0xAA0, 0xAA8, 0xAAC, 0xAB0, 0xAB4, 0xAB8, 0xABC, 0xAC0, 
	0xAD0, 0xAD4, 0xAD8, 0xADC, 0xAE0, 0xAE8, 0xAEC, 0xAF0, 
	0xAF4, 0xAF8, 0xAFC, 0xB00, 0xB40, 0xB50, 0xB54, 0xB58, 
	0xB5C, 0xB60, 0xB68, 0xB6C, 0xB70, 0xB74, 0xB78, 0xB7C, 
	0x2F4, 0x2F8, 0x2FC, 0x300, 0x340, 0x350, 0x354, 0x358, 
	0x35C, 0x360, 0x368, 0x36C, 0x370, 0x374, 0x378, 0x37C, 
	0x380, 0x3A0, 0x3A8, 0x3AC, 0x3B0, 0x3B4, 0x3B8, 0x3BC, 
	0x3C0, 0x3D0, 0x3D4, 0x3D8, 0x3DC, 0x3E0, 0x3E8, 0x3EC, 
	0x3F0, 0x3F4, 0x3F8, 0x3FC, 0x400, 0x500, 0x540, 0x550, 
	0x554, 0x558, 0x55C, 0x560, 0x568, 0x56C, 0x570, 0x574, 
	0x578, 0x57C, 0x580, 0x5A0, 0x5A8, 0x5AC, 0x5B0, 0x5B4, 
	0x5B8, 0x5BC, 0x5C0, 0x5D0, 0x5D4, 0x5D8, 0x5DC, 0x5E0, 
	0x5E8, 0x5EC, 0x5F0, 0x5F4, 0x5F8, 0x5FC, 0x600, 0x680, 
	0x6A0, 0x6A8, 0x6AC, 0x6B0, 0x6B4, 0x6B8, 0x6BC, 0x6C0, 
	0x6D0, 0x6D4, 0x6D8, 0x6DC, 0x6E0, 0x6E8, 0x6EC, 0x6F0, 
	0x6F4, 0x6F8, 0x6FC, 0x700, 0x740, 0x750, 0x754, 0x758
};

char *varienc(unsigned char c)
{
	return varicode[c];
}

int varidec(unsigned int symbol)
{
	int i;

	for (i = 0; i < 256; i++)
		if (symbol == varidecode[i])
			return i;

	return -1;
}

