#ifndef _FFT_H
#define _FFT_H

#ifdef HAVE_LIBFFTW
#include <fftw.h>
#endif

#include "cmplx.h"

struct fft {
#ifdef HAVE_LIBFFTW
	fftw_plan plan;
#else
	int dir;
        int fftlen;
        int fftlenlog;
        complex *twiddles;
        unsigned int *bitrev;
#endif
};

extern struct fft *init_fft(int len);
extern struct fft *init_ifft(int len);

extern void clear_fft(struct fft *s);

extern void fft(struct fft *s, complex *in, complex *out);

#endif
