  	/* ------------------------------------------------------------
 	*        Callinput handles the call input field
 	*
 	*--------------------------------------------------------------*/

#include "callinput.h"
#include "addspot.h"
#include "changefreq.h"

int callinput(void)
{
extern int contest;
extern int dxped;
extern char hiscall[];
extern char comment[];
extern char call[];
extern int cqmode;
extern int trxmode;
extern char mode[];
extern char lastcall[];
extern char band[9][4];
extern int bandinx;
extern char speedstr[];
extern int keyspeed;
extern int cqdelay;
extern char his_rst[];
extern int qsonum;
extern char qsonrstr[];
extern char backgrnd_str[];
extern int demode;
extern char buffer[];
extern char message[15][80];
extern int cury, curx;
extern char logline0[];
extern char logline1[];
extern char logline2[];
extern char logline3[];
extern char logline4[];
extern int trx_control;
extern float freq;
extern float mem;
extern float bandfrequency[];

int  i, j, x = 0, inchar;
char instring[2];
char dupecall[17];
char speedbuf[3] = "";
char qrgoutstring[9];

FILE *fp;

instring[1] = '\0';

attron(COLOR_PAIR(NORMCOLOR) | A_BOLD );
mvprintw(12, 29, "            ");
printcall();
	
	for  (i= strlen(hiscall) ; i <= 19 ; i++)
	{
         	time_update();
         	
		
		if  (i == 0 || strlen(hiscall)  == 0)
		{
			nodelay(stdscr, TRUE);            /* main loop waiting for input */
			x =-1;		
			while  (x  <= 1 ){	
			
				time_update();
			
			
				x = onechar();
			
		
				}
		 	nodelay(stdscr, FALSE);
		 	
		 	
		 	if (x == '+' && strlen(hiscall)  ==  0){
		 		if (cqmode  == CQ ){
		 			cqmode = S_P ;	
		 		}
		 		else
		 			cqmode = CQ ;
		 		
		 		attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
		 		
		 		if (cqmode == CQ ){
		 			mvprintw(0,2, "Log     ");
		 			strcpy(mode, "Log     ");
		 			}
		 		else{
		 			mvprintw(0,2, "S&P     ");
		 			strcpy(mode, "S&P     ");
		 			}
		 		cleanup();
			}
					 	
		 	if (x == '\n' && strlen(hiscall)  ==  0){
				if (cqmode == CQ )
					auto_cq();
				else
					sendspcall();
				break;
			    }
			
			 if  (x == '@' && strlen(hiscall)  == 0){
				 	edit_last();
					break;			
			 }
			
			 if (x == '=' && strlen(hiscall)  == 0){
			         strcat(buffer, lastcall);
			         strcat(buffer, " OK ");
			         sendbuf();
			         break;
			 } else if  (x  ==  '=' && strlen(hiscall) !=  0){
			  		strcat(buffer, lastcall);
			  		strcat(buffer,  " OK ");
			  		sendbuf();
			  		break;
			 }
		}
		else

			x = onechar();
			
		switch  (x)
		{
		 	case 155:		/* left */
		 	{
		
		 	    if (strlen(hiscall) != 0){
		 	     	calledit();
		 	    }
		 		
		 		if  (bandinx >= 1 &&  strlen(hiscall) == 0){
		 			
		 			bandinx--;
		 				
		 			if ((contest == 1) && (dxped == 0) &&((bandinx == 3) || (bandinx == 5) || (bandinx == 7)))
		 					bandinx--;
		 			
		 			attron(COLOR_PAIR(COLOR_CYAN) | A_STANDOUT);
		 			mvprintw(12, 0, band[bandinx]);
		 			printcall();
		 			i--;
		 			
		 			if (trx_control == 1) {
		 				
		 				if ((fp = fopen("QRGOUT" , "w")) != NULL) {
	 						sprintf(qrgoutstring, "%5.1f", bandfrequency[bandinx]);
	 						fputs(qrgoutstring, fp);
	 						fclose(fp);
	 					} else
                            mvprintw(24,0, "Cannot write to QRGOUT");
		 			}
		 			
		 			
		 		}

		 		break;
		 	}
		 	case 154:		/* right */
		 	{
		 	 	if  (bandinx <=  7  && strlen(hiscall) == 0){
		 	 		bandinx++;
		 	 		if ((contest == 1) && (dxped == 0) && ((bandinx == 3) || (bandinx == 5) || (bandinx == 7)))
		 	 			bandinx++;
		 	 		attron(COLOR_PAIR(COLOR_CYAN) | A_STANDOUT);
		 	 		mvprintw(12, 0, band[bandinx]);
		 	 		attron(COLOR_PAIR(NORMCOLOR) | A_BOLD );
		 			attron(A_STANDOUT);
		 			mvprintw(12, 29 +  strlen(hiscall), "");
		 			
		 				if (trx_control == 1) {
		 					freq = bandfrequency[bandinx];
		 					
		 					if ((fp = fopen("QRGOUT" , "w")) != NULL) {
	 							sprintf(qrgoutstring, "%5.1f", bandfrequency[bandinx]);
	 							fputs(qrgoutstring, fp);
	 							fclose(fp);
	 						} else
                            	mvprintw(24,0, "Cannot write to QRGOUT");
		 				}

		 	 		}
		 	 	break;
		 	}
		 	case 152:
				{
					keyspeed = speedup();
					strncpy(speedbuf, speedstr +  (2  *  keyspeed), 2);
					speedbuf[2] =  '\0';
					attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
		 			
		 			mvprintw(0, 14, "%s", speedbuf);
					printcall();
					break;
				}
				case 153:
				{
					keyspeed = speeddown();
					strncpy(speedbuf, speedstr +  (2  *  keyspeed), 2);
					speedbuf[2] =  '\0';
					attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
		 			mvprintw(0, 14, "%s", speedbuf);
		 			attron(COLOR_PAIR(NORMCOLOR)  | A_BOLD );
		 			
		 			mvprintw(12, 29 +  strlen(hiscall)  , "");
					break;
				}
				case 156:
				{
				  if (strlen(hiscall) != 0){
					
					if (his_rst[1] <= 56){
						 	 	
						his_rst[1]++;
						 	 	
						mvprintw(12, 44, his_rst);
						mvprintw(12, 29, hiscall);
					}
				
				  } else {
				
					if  (cqdelay <= 60){
						cqdelay++;
						attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
		 				mvprintw(0, 19, "  ");
		 				mvprintw(0, 19, "%i",  cqdelay);
		 				attron(COLOR_PAIR(NORMCOLOR) | A_BOLD );
		 				mvprintw(12, 29 +  strlen(hiscall)  , "");
					 }
                  }
					break;
					
				}
				case 157:
				{
				  if (strlen(hiscall) != 0) {	
					
					if (his_rst[1] >= 49){
				 	 	his_rst[1]--;

				 	 	mvprintw(12, 44, his_rst);
				 	 	mvprintw(12, 29, hiscall);
                    }
				
				  } else {
				
		 			if (cqdelay >= 1){
				 		cqdelay--;
				 		attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
		 				
		 				mvprintw(0, 19, "  ");
		 				mvprintw(0, 19, "%i",  cqdelay);
				 	    printcall();
				 	}	
                  }
				 		break;
				 	
				}
				case 160:
				{
					if (strlen(hiscall) >= 3 )
    				{
						scroll_log();
  		 	
   		 				addcall();
  		 	
						makelogline();

						hiscall[0] = '\0';	/* reset the call  string */
						hiscall[20] = '\0';
						comment[0] = '\0';	/* reset the comment  string */
						comment[30] = '\0';
			
						attron(COLOR_PAIR(NORMCOLOR) | A_BOLD);    /* erase comment  field */
						mvprintw(12, 54, "                          ");
	
						attron(COLOR_PAIR(7) | A_STANDOUT);
						mvprintw(7,  0, logline0);
						mvprintw(8,  0, logline1);
						mvprintw(9,  0, logline2);
						mvprintw(10,  0, logline3);
						mvprintw(11,  0, logline4);
  						refresh();

    					store_qso();

    					qsonum++;
    					qsonr_to_str();

    					attron(COLOR_PAIR(COLOR_CYAN));
    					mvprintw(12, 23, qsonrstr);

	                    mvprintw(12,29, "            ");
	                    printcall();
	
					} /* end of if */
					break;
				}
				case 58:
				{
					changepars();
					hiscall[0]='\0';
					x = 0;
					clear_display();
					attron(COLOR_PAIR(7)  |  A_STANDOUT);

					for (j = 13 ;  j  <= 23 ; j++){
	 					mvprintw(j, 0, backgrnd_str);
						}

					attron(COLOR_PAIR(NORMCOLOR) | A_BOLD   );
					mvprintw(12, 29, "            ");
					mvprintw(12, 29, "");
					refresh();
					break;
				}
				case 35:
				{
				     if (mem == 0.0) {
				     	mem = freq;
				     	
				     	if (freq >= 7300.0)
				     		mvprintw(14, 68, "MEM: %5.1f",mem);
				     	else
				     		mvprintw(14, 68, "MEM:  %5.1f",mem);
				     }
				     else {
				     	freq = mem;
				     	if ((fp = fopen("QRGOUT" , "w")) != NULL) {
	 						sprintf(qrgoutstring, "%5.1f", mem);
	 						fputs(qrgoutstring, fp);
	 						fclose(fp);
	 	}
	 	else
	 		mvprintw(24,0, "QRGOUT file can not be opened");

				     	mem = 0.0;
				     	mvprintw(14, 68, "            ");
				     }
					mvprintw(29,12, " ");
					mvprintw(29,12, "");
					refresh();
					break;
				}	
				case 45:
				{
				     delete_qso();
					break;
				}	

				
				case 59:
				{
					include_note();
					cleanup();
					x=-1;
					break;
				}	

				case 129:       /*  F1 */
				{
					switch (cqmode){
						case 0:{
							if (demode == SEND_DE )
								strcat(buffer, "DE ");
					    	strcat(buffer, call);       /* S&P */
					    	break;
					    	}
						case 1:
						strcat(buffer, message[0]);       /* CQ */
					}	
					
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 130:
				{
					strcat(buffer, message[1]);       /* F2 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 131:
				{
					strcat(buffer, message[2]);        /* F3 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");					
					break;
				}
				case 132:
				{
					strcat(buffer, message[3]);       /* F4 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 133:
				{
					strcat(buffer, message[4]);        /* F5 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 134:
				{
					strcat(buffer, message[5]);        /* F6 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 135:
				{
					strcat(buffer, message[6]);        /* F7 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 136:
				{
					strcat(buffer, message[7]);       /* F8 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 137:
				{
					strcat(buffer, message[8]);       /* F9 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 138:
				{
					strcat(buffer, message[9]);       /* F10 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
			
				 case 140:
				{
					strcat(buffer, message[10]);       /* F11 */
					sendbuf();
					mvprintw(12, 29 +  strlen(hiscall), "");
					break;
				}
				case 141:          					  /* F12 */
				{
					if (trxmode != CWMODE)           /* only if CW */
						break;
					
					strcpy (mode,  "AUTO_CQ ");
    				clear_display();
					nodelay(stdscr,  TRUE);
				    while (1){
				        strcat(buffer, message[11]);
						sendbuf();
						mvprintw(12, 29 +  strlen(hiscall), "");
						inchar =  getch();
						if  (inchar  != ERR){
							mvprintw(12, 29,"             ");
							break;
							}
						attron(COLOR_PAIR(NORMCOLOR) | A_BOLD );
						mvprintw(12, 29," sleeping... ");
						refresh();
						sleep(2);
						printcall();
						inchar =  getch();
						if  (inchar  != ERR){
							mvprintw(12, 29,"             ");
							break;
							}
						sleep(cqdelay);
						inchar =  getch();
						if  (inchar  != ERR){
							mvprintw(12, 29,"             ");
							break;
							}
						mvprintw(12, 29,  "            ");
						mvprintw(12,29,  "");
						refresh();
					}
					if  (cqmode  == CQ )
 						strcpy (mode, "Log     ");
 					else
 						strcpy(mode , "S&P     ");
 						
    				clear_display();
					attron(COLOR_PAIR(NORMCOLOR) | A_BOLD  );
					mvprintw(12, 29,"             ");
					printcall();
					nodelay(stdscr, FALSE);
					break;
				}
		 		case 127:
		 		{
		 	 		if  (strlen(hiscall) >= 1){
		 				getyx(stdscr, cury,  curx);
			 			mvprintw(12, curx - 1, " ");
			 			mvprintw(12, curx  - 1, "");
						hiscall[strlen(hiscall)-1] = '\0';
						
						if (atoi(hiscall) <= 9) {              /*  no frequency */
							strncpy(dupecall,  hiscall, 16);

							x =  getctydata(dupecall);

							showinfo(x);

							searchlog(hiscall);
							refresh();
					}

						i--;
						x = -1;
			 			break;
			 			}
			
		 		}
		 		case 27:
			 	{
			 		cleanup();

			 		break;
			 	}
		 		case 95:
			 	{
			 		prev_qso();
			 		
			 		break;
			 	}
		 		case '!':
			 	{
			 		endwin();
			 		system ("clear");
			 		system("sh");
			 		system ("clear");
			 		initscr();
			 		clear_display();
			 		
			 		break;
			 	}
			 	case 16:
			 	{
			 		muf();
			 		clear_display();
			 		
			 		break;
			 	}
     			case 1:
			 	{
			 		addspot();
			 		
			 		break;
			 	}
			 	case 6:
			 	{
			 		change_freq();
			 		
			 		break;
			 	}
     			case 7:
			 	{
			 		grabspot();
			 		clear_display();
			 		
			 		break;
			 	}


			}	


				if (x >= 97 && x <=  122)
					x = x - 32 ;
				if (x >= 47 && x <=  90)
				{
					instring[0] = x;
					addch(x);
					strcat(hiscall, instring);
					refresh();
					
					if (atoi(hiscall) <= 9) {              /*  no frequency */
						strncpy(dupecall,  hiscall, 16);

						x =  getctydata(dupecall);

						showinfo(x);

						searchlog(hiscall);
						refresh();
					}else {
						attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
						mvprintw(24,0, "                                                           ");	
						mvprintw(12,29 + strlen(hiscall), "");
					}
				}
							

				if ((x == '\n') || x == 32 || x == 9 ||  x == 11 || x == 44 || x == 92)
					break;
					
			  	time_update();			
		}
		

	
return(x);
}
