 	/* ------------------------------------------------------------
 	*        Set Cw sidetone
 	*
 	*--------------------------------------------------------------*/

#include "set_tone.h"
#include "tlf.h"
#include "cwkeyer.h"
#include "clear_display.h"
#include "write_tone.h"

 int set_tone(void)
 {

 extern char speedstr[];
 extern int speed;
 extern char tonestr[];
 extern int trxmode;

 char speedbuf[3] = "  ";

if (trxmode != CWMODE)
	return(1);

strncpy(speedbuf, speedstr  + (2 * speed)  ,2);
speedbuf[2] =  '\0';


 nicebox (4,  40, 1, 6 , "Tone");
 mvprintw(5, 42,  "");
 attron(COLOR_PAIR(7) | A_STANDOUT);
 echo();
 getnstr(tonestr,  3);
 noecho();
 tonestr[4] = '\0';

 write_tone();


  return(0);
 }

void write_tone(void)
{

	extern int trxmode;
 	extern char speedstr[];
 	extern int speed;
 	extern char tonestr[];
	extern int keyerport;
	extern int cfd;
	
	char outstr[20] = "";
 	char speedbuf[3] = "  ";
 	int mute = 1;
	

if (keyerport == COM1_KEYER) {
	
	strncpy(speedbuf, speedstr  + (2 * speed)  ,2);  /* output to keyer */
	speedbuf[2] =  '\0';

	
	strcpy(outstr , "cwkeyset ");
	strcat(outstr, tonestr);
	strcat(outstr  ,  " ");
	strcat (outstr, speedbuf);
	system(outstr);
}  else {

 if (keyerport == LPT_KEYER) {
 	
		if (atoi(tonestr) == 0)
 			mute = 1;
 		else
 			mute = 0;
		
		if (mute == 0) {
		    if	(ioctl(cfd,CWKEYER_IOCSMONI, 1 ))
			{
				printf(" Unable to switch on  sidetone\n");
			}
			
			if	(ioctl(cfd, CWKEYER_IOCSFREQ, atoi(tonestr)))
			{
				mvprintw(24,0, "keyer not active; switching to SSB");
				trxmode = SSBMODE;
				clear_display();

			}
		
		}else {
		
			if	(ioctl(cfd,CWKEYER_IOCSMONI, 0 ))
			{
				mvprintw(24,0, "keyer not active; switching to SSB");
				trxmode = SSBMODE;
				clear_display();

			}	
		
		}
		
	}

   }
}


