/*
 *  Copyright (C) 2000-2001 Marco Pesenti Gritti, Jorn Baayen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __favicon_h
#define __favicon_h

#ifdef __cplusplus
extern "C" {
#endif

#include "bookmarks.h"

typedef enum
{
	FAVICON_DOWNLOAD_LINK_ICON = 1 << 0, /* get the link rel=.. icon    */
	FAVICON_DOWNLOAD_HOST_ICON = 1 << 1, /* get host/favicon.ico        */
	FAVICON_DOWNLOAD_OVERWRITE = 1 << 2  /* overwrite any existing icon */
} FaviconDownloadFlags;
	
typedef struct
{
	GaleonEmbed *embed;  /* embed associated with the operation       */
	BookmarkItem *b;     /* bookmark for which the icon is downloaded */
	gboolean host_icon;  /* is this a host/favicon.ico                */
	gchar *favicon_path; /* path of the downloaded icon               */
	gchar *url;          /* url of the icon                           */
} FaviconInfo;

void favicon_download (GaleonEmbed *embed, BookmarkItem *b, FaviconDownloadFlags flags);
gchar *favicon_filename (gchar *favicon_url);
void favicon_download_completed (FaviconInfo *info);
void favicon_update_drag_handle (GaleonEmbed *embed, gboolean fetch);
const PixmapData *favicon_get_pixmap (const gchar *url);
void favicon_key_files_close (void);
void favicon_key_files_init (void);

#ifdef __cplusplus
}
#endif

#endif /* __favicon_h */
