/***************************************************************************
                            kde_KApplication.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KAPPLICATION
#define KDE_KAPPLICATION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Controls and provides information to all KDE applications.

 Only one object of this class can be instantiated in a single app.
 This instance is always accessible via the @ref kApplication() method.

 This class provides the following services to all KDE applications.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: kde_KApplication.h,v 1.3 2002/02/21 00:43:08 rdale Exp $

 @short Controls and provides information to all KDE applications.

*/
#define KAPPLICATION_CaptionAppLast	1
#define KAPPLICATION_CaptionAppFirst	0
#define KAPPLICATION_CaptionNoApp	1
#define KAPPLICATION_ShutdownConfirmDefault	-1
#define KAPPLICATION_	0
#define KAPPLICATION_ShutdownConfirmNo	0
#define KAPPLICATION_Alwaysconfirm	1
#define KAPPLICATION_ShutdownConfirmYes	1
#define KAPPLICATION_ShutdownTypeDefault	-1
#define KAPPLICATION_ShutdownTypeNone	0
#define KAPPLICATION_ShutdownTypeReboot	1
#define KAPPLICATION_ShutdownTypeHalt	2
#define KAPPLICATION_ShutdownModeDefault	-1
#define KAPPLICATION_ShutdownModeSchedule	0
#define KAPPLICATION_Shutdown	0
#define KAPPLICATION_ShutdownModeTryNow	1
#define KAPPLICATION_ShutdownModeForceNow	2
#define KAPPLICATION_SETTINGS_MOUSE	0
#define KAPPLICATION_SETTINGS_COMPLETION	1
#define KAPPLICATION_SETTINGS_PATHS	2
#define KAPPLICATION_SETTINGS_POPUPMENU	3
#define KAPPLICATION_SETTINGS_QT	4
#define KAPPLICATION_SETTINGS_SHORTCUTS	5

/** 
 This constructor takes aboutData and command line
  arguments from @ref KCmdLineArgs.

*/
kde_KApplication * kde_new_KApplication(int allowStyles, int GUIenabled);

/** 
 Constructor. Parses command-line arguments. Use this constructor to use KApplication
 in a Motif or Xt program.

*/
//kde_KApplication * kde_new_KApplication1(Display* display, int argc, char** argv, qt_QCString* rAppName, int allowStyles, int GUIenabled);

/** 

 Constructor. Parses command-line arguments.

*/
kde_KApplication * kde_new_KApplication2(int argc, char** argv, qt_QCString* rAppName, int allowStyles, int GUIenabled);
void kde_del_KApplication( kde_KApplication* p );

/** 
 Returns the application session config object.

*/
kde_KConfig* kde_KApplication_sessionConfig(kde_KApplication* instPointer);

/** 
 Is the application restored from the session manager?

*/
int kde_KApplication_isRestored(kde_KApplication* instPointer);

/** 
 Disables session management for this application.

 Useful in case  your application is started by the
 initial "startkde" script.
   
*/
void kde_KApplication_disableSessionManagement(kde_KApplication* instPointer);

/** 
 Asks the session manager to shut the session down.

 Using confirm == ShutdownConfirmYes or sdtype != ShutdownTypeDefault or
 sdmode != ShutdownModeDefault causes the use of ksmserver's DCOP
 interface. The remaining two combinations use the standard XSMP and
 will work with any session manager compliant with it.

 Returns TRUE on sucess, FALSE if the session manager could not be
 contacted.
   
*/
int kde_KApplication_requestShutDown(kde_KApplication* instPointer,int confirm, int sdtype, int sdmode);

/** 
 Propagates the network address of the session manager in the
 SESSION_MANAGER environment variable so that child processes can
 pick it up.

 If SESSION_MANAGER isn't defined yet, the address is searched in
 $HOME/.KSMserver.

 This function is called by clients that are started outside the
 session ( i.e. before ksmserver is started), but want to launch
 other processes that should participate in the session.  Examples
 are kdesktop or kicker.
   
*/
void kde_KApplication_propagateSessionManager(kde_KApplication* instPointer);
void kde_KApplication_commitData(kde_KApplication* instPointer,qt_QSessionManager* sm);
void kde_KApplication_saveState(kde_KApplication* instPointer,qt_QSessionManager* sm);

/** 
 Returns a @ref QPixmap with the application icon.
   
*/
qt_QPixmap * kde_KApplication_icon(kde_KApplication* instPointer);

/** 
 Returns the name of the application icon.
   
*/
qt_QString * kde_KApplication_iconName(kde_KApplication* instPointer);

/** 
 Returns the mini-icon for the application as a @ref QPixmap.
   
*/
qt_QPixmap * kde_KApplication_miniIcon(kde_KApplication* instPointer);

/** 
 Returns the name of the mini-icon for the application.
   
*/
qt_QString * kde_KApplication_miniIconName(kde_KApplication* instPointer);

/** 
   Sets the top widget of the application.

  This means basically applying the right window caption and
  icon. An application may have several top widgets. You don't
  need to call this function manually when using @ref KMainWindow.

*/
void kde_KApplication_setTopWidget(kde_KApplication* instPointer,qt_QWidget * topWidget);

/** 
 Invokes the KHelpCenter HTML help viewer from docbook sources.

*/
void kde_KApplication_invokeHelp(kde_KApplication* instPointer,qt_QString * anchor, qt_QString * appname);

/** 

 Invoke the khelpcenter HTML help viewer from HTML sources.
 Please use invokeHelp() instead.

*/
void kde_KApplication_invokeHTMLHelp(kde_KApplication* instPointer,qt_QString * aFilename, qt_QString * aTopic);

/** 
 Convenience method; invokes the standard email application.

*/
void kde_KApplication_invokeMailer(kde_KApplication* instPointer,qt_QString * address, qt_QString * subject);

/** 
 Invokes the standard email application.

*/
void kde_KApplication_invokeMailer1(kde_KApplication* instPointer,kde_KURL* mailtoURL);

/** 
 Convenience method; invokes the standard email application.

 All parameters are optional.

*/
void kde_KApplication_invokeMailer2(kde_KApplication* instPointer,qt_QString * to, qt_QString * cc, qt_QString * bcc, qt_QString * subject, qt_QString * body, qt_QString * messageFile, qt_QStringList* attachURLs);

/** 
 Invokes the standard browser.

*/
void kde_KApplication_invokeBrowser(kde_KApplication* instPointer,qt_QString * url);

/** 
 Returns a text for the window caption.

 This may be set by
 "-caption", otherwise it will be equivalent to the name of the
 executable.
   
*/
qt_QString * kde_KApplication_caption(kde_KApplication* instPointer);

/** 

   
*/
//kde_KStyle* kde_KApplication_kstyle(kde_KApplication* instPointer);

/** 
 Builds a caption that contains the application name along with the
 @ref userCaption() using a standard layout.

 To make a compliant caption
 for your window, simply do: @p setCaption(kapp->makeStdCaption(yourCaption));

*/
qt_QString * kde_KApplication_makeStdCaption(kde_KApplication* instPointer,qt_QString * userCaption, int withAppName, int modified);

/** 
 Get a file name in order to make a temporary copy of your document.

*/
qt_QString * kde_KApplication_tempSaveName(kde_KApplication* instPointer,qt_QString * pFilename);

/** 
 Check whether  an auto-save file exists for the document you want to
 open.

*/
qt_QString * kde_KApplication_checkRecoverFile(kde_KApplication* instPointer,qt_QString * pFilename, int bRecover);

/** 
 Get the X11 display
   
*/
//Display* kde_KApplication_getDisplay(kde_KApplication* instPointer);

/** 
 Enables style plugins.

 This is useful only to applications that normally
 do not display a GUI and create the KApplication with
 allowStyles set to false.
   
*/
void kde_KApplication_enableStyles(kde_KApplication* instPointer);

/** 
 Disables style plugins.

 Current style plugins do not get unloaded.

 This is only useful when used in combination with @ref enableStyles.
   
*/
void kde_KApplication_disableStyles(kde_KApplication* instPointer);

/** 
  Installs widget filter as global X11 event filter.

 The widget
  filter receives XEvents in its standard @ref QWidget::x11Event() function.

  Warning: Only do this when absolutely necessary. An installed X11 filter
  can slow things down.

*/
void kde_KApplication_installX11EventFilter(kde_KApplication* instPointer,qt_QWidget * filter);

/** 
 Adds a message type to the KIPC event mask. You can only add "system
 messages" to the event mask. These are the messages with id < 32.
 Messages with id >= 32 are user messages.

*/
void kde_KApplication_addKipcEventMask(kde_KApplication* instPointer,int identifier);

/** 
 Removes a message type from the KIPC event mask. This message will not
 be handled anymore.

*/
void kde_KApplication_removeKipcEventMask(kde_KApplication* instPointer,int identifier);

/** 
 Returns the app startup notification identifier for this running application.
   
*/
qt_QCString* kde_KApplication_startupId(kde_KApplication* instPointer);

/** 
 Sets a new value for the application startup notification window property for newly
 created toplevel windows.
   
*/
void kde_KApplication_setStartupId(kde_KApplication* instPointer,qt_QCString* startup_id);

/** 
 Returns the argument to --geometry if any, so the geometry can be set
 wherever necessary
    
*/
qt_QString * kde_KApplication_geometryArgument(kde_KApplication* instPointer);

/** 
 Install a Qt SQL property map with entries for all KDE widgets
 Call this in any application using KDE widgets in QSqlForm or QDataView.
   
*/
void kde_KApplication_installKDEPropertyMap(kde_KApplication* instPointer);

/** 

   
*/
int kde_KApplication_notify(kde_KApplication* instPointer,qt_QObject * receiver, qt_QEvent * event);

/** 

    
*/
int kde_KApplication_xioErrhandler(kde_KApplication* instPointer);

/** 

   
*/
//void kde_KApplication_iceIOErrorHandler(kde_KApplication* instPointer,_IceConn* conn);

/** 
 Tells KApplication about one more operation that should be finished
 before the application exits. The standard behavior is to exit on the
 "last window closed" event, but some events should outlive the last window closed
 (e.g. a file copy for a file manager, or 'compacting folders on exit' for a mail client).
   
*/
void kde_KApplication_ref(kde_KApplication* instPointer);

/** 
 Tells KApplication that one operation such as those described in @ref ref just finished.
 The application exits if the counter is back to 0.
   
*/
void kde_KApplication_deref(kde_KApplication* instPointer);

/** 
 Add Qt and KDE command line options to KCmdLineArgs.
    
*/
void kde_KApplication_addCmdLineOptions( );

/** 
 Returns the current application object.

 This is similar to the global @ref QApplication pointer qApp. It
 allows access to the single global KApplication object, since
 more than one cannot be created in the same application. It
 saves you the trouble of having to pass the pointer explicitly
 to every function that may require it.
   
*/
kde_KApplication* kde_KApplication_kApplication( );

/** 
 Returns a pointer to a @ref DCOPClient for the application.
 If a client does not exist yet, it is created when this
 function is called.
   
*/
kde_DCOPClient* kde_KApplication_dcopClient( );

/** 
 Disable automatic dcop registration
 Must be called before creating a KApplication instance to have an effect.
   
*/
void kde_KApplication_disableAutoDcopRegistration( );

/** 
 Returns the DCOP name of the service launcher. This will be something like
 klaucher_$host_$uid.
   
*/
qt_QCString* kde_KApplication_launcher( );

/** 
 Starts a service based on the (translated) name of the service.
 E.g. "Web Browser"

*/
int kde_KApplication_startServiceByName( qt_QString * _name, qt_QString * URL, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);
int kde_KApplication_startServiceByName1( qt_QString * _name, qt_QStringList* URLs, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** 
 Starts a service based on the desktop path of the service.
 E.g. "Applications/konqueror.desktop" or "/home/user/bla/myfile.desktop"

*/
int kde_KApplication_startServiceByDesktopPath( qt_QString * _name, qt_QString * URL, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);
int kde_KApplication_startServiceByDesktopPath1( qt_QString * _name, qt_QStringList* URLs, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** 
 Starts a service based on the desktop name of the service.
 E.g. "konqueror"

*/
int kde_KApplication_startServiceByDesktopName( qt_QString * _name, qt_QString * URL, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);
int kde_KApplication_startServiceByDesktopName1( qt_QString * _name, qt_QStringList* URLs, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** 
 Starts a program via kdeinit.
 There will be no application startup notification, so you should
 use it only for starting internal processes.

 program name and arguments are converted to according to the
 local encoding and passed as is to kdeinit.

*/
int kde_KApplication_kdeinitExec( qt_QString * name, qt_QStringList* args, qt_QString* error, int* pid);

/** 
 Starts a program via kdeinit and wait for it to finish.

 Like kdeinitExec but it waits till the program is finished.
 As such it behaves similar to the system(...) function.
   
*/
int kde_KApplication_kdeinitExecWait( qt_QString * name, qt_QStringList* args, qt_QString* error, int* pid);

/** 
 Generates a uniform random number.

*/
int kde_KApplication_random( );

/** 
 Generates a random string.  It operates in the range [A-Za-z0-9]

*/
qt_QString * kde_KApplication_randomString( int length);

/** 

   
*/
void kde_KApplication_startKdeinit( );

/** 

   
*/
kde_KApplication * kde_new_KApplication3(int allowStyles, int GUIenabled, kde_KInstance* _instance);

/** 
 Used to catch X11 events
   
*/
//int kde_KApplication_x11EventFilter(kde_KApplication* instPointer,XEvent* arg1);

/** Casts a 'kde_KApplication *' to a 'kde_KInstance*' */
kde_KInstance* kde_KApplication_KInstance(kde_KApplication* instPointer);

/** Casts a 'kde_KApplication *' to a 'qt_QApplication*' */
qt_QApplication* kde_KApplication_QApplication(kde_KApplication* instPointer);

#endif
