/***************************************************************************
                            kde_KCharsets.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCHARSETS
#define KDE_KCHARSETS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Charset font and encoder/decoder handling.

 This is needed, because Qt's font matching algorithm gives the font
 family a higher priority than the charset.  For many applications
 this is not acceptable, since it can totally obscure the output,
 in languages which use non iso-8859-1 charsets.

 @author Lars Knoll <knoll@kde.org>

 @version $Id: kde_KCharsets.h,v 1.4 2002/02/21 00:43:09 rdale Exp $
 
 @short 
 Charset font and encoder/decoder handling.
*/

/**  destructor 
*/
void kde_del_KCharsets( kde_KCharsets* p );

/** 
 provided for compatibility.
     
*/
qt_QTextCodec* kde_KCharsets_codecForName(kde_KCharsets* instPointer,qt_QString * name);

/** 
 tries to find a QTextCodec to convert the given encoding from and to
 Unicode. If no codec could be found the latin1 codec will be returned an
 ok will be set to false.
     
*/
qt_QTextCodec* kde_KCharsets_codecForName1(kde_KCharsets* instPointer,qt_QString * n, int ok);

/** 
 Lists all available encodings as names.
     
*/
qt_QStringList* kde_KCharsets_availableEncodingNames(kde_KCharsets* instPointer);

/** 
 Lists the available encoding names together with a more descriptive language.
     
*/
qt_QStringList* kde_KCharsets_descriptiveEncodingNames(kde_KCharsets* instPointer);

/** 
 Lists all languages.
     
*/
//qt_QStringList* kde_KCharsets_languages(kde_KCharsets* instPointer);

/** 
 Lists all available encodings for language name 'language'.
     
*/
//qt_QStringList* kde_KCharsets_encodingsForLanguage(kde_KCharsets* instPointer,qt_QString * language);

/** 
 returns the language the encoding is used for. 
     
*/
qt_QString * kde_KCharsets_languageForEncoding(kde_KCharsets* instPointer,qt_QString * encoding);

/** 
 returns the encoding for a string obtained with descriptiveEncodingNames()
     
*/
qt_QString * kde_KCharsets_encodingForName(kde_KCharsets* instPointer,qt_QString * descriptiveName);

/** 
 converts an entity to a character. The string must contain only the
 entity without the trailing ';'.

*/
qt_QChar* kde_KCharsets_fromEntity( qt_QString * str);

/** 
 Overloaded member function. Tries to find an entity in the
 @ref QString str.

*/
qt_QChar* kde_KCharsets_fromEntity1( qt_QString * str, int len);

/** 
 converts a QChar to an entity. The returned string does already
 contain the leading '&' and the trailing ';'.
     
*/
qt_QString * kde_KCharsets_toEntity( qt_QChar* ch);

/**  protected constructor. If you need the kcharsets object, use
        @ref KGlobal::charsets() instead.
    
*/
kde_KCharsets * kde_new_KCharsets();

#endif
